<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use Carbon\Carbon;

class FetchJsonDataDaily extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'app:fetch-json-data-daily';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Command description';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        $url = 'https://api-in21.leadsquared.com/v2/LeadManagement.svc/Leads/Retrieve/BySearchParameter?accessKey=u$rab774ce6190a55b000eda581cf924675&secretKey=a8cf026741d168af7a501e791490b314ece978ea';

        $payload = [
            "SearchParameters" => [
                "AdvancedSearchTextNew" => "{\"GrpConOp\":\"And\",\"Conditions\":[{\"Type\":\"Lead\",\"ConOp\":\"or\",\"RowCondition\":[{\"SubConOp\":\"And\",\"LSO\":\"mx_Dummy_Dropdown_1\",\"LSO_Type\":\"PickList\",\"Operator\":\"eq\",\"RSO\":\"Application Process Completed\",\"RSO_IsMailMerged\":false},{\"RSO\":\"\"},{\"RSO\":\"\"}]}],\"QueryTimeZone\":\"India Standard Time\"}",
                "Columns" => [
                    "Include_CSV" => "ProspectID,FirstName,LastName,EmailAddress,mx_Dummy_Dropdown_8,mx_Dummy_Dropdown_9,mx_Programme,mx_Duration,mx_Batch,mx_Registration_On,mx_Dummy_Text_21,mx_Admission_Number,mx_Dummy_Text_25,mx_Middle_Name,Phone,mx_DOB,mx_Gender,mx_Blood_Group,mx_Nationality,mx_Emergency_Contact_Number,mx_Permanent_Address,mx_Dummy_Dropdown_7,mx_Dummy_Dropdown_5,mx_Dummy_Dropdown_6,mx_Permanent_Address_Zip_Code,mx_Dummy_Dropdown_4,mx_Dummy_Dropdown_2,mx_Present_Address_Details,mx_Dummy_Dropdown_3,mx_Present_Address_Zip_Code,mx_Fathers_Name,mx_Mothers_Name,mx_Parent_Guardian_Details_1,mx_Parent_Guardian_Details_2,mx_Loan,mx_Number_Field_1,mx_Total_Amount_paid_by_Student"
                ],
                "EntityType" => 1,
                "Paging" => [
                    "PageIndex" => 1,
                    "PageSize" => 1000
                ],
                "DefinitionType" => "1"
            ]
        ];

        try {
            $response = Http::withHeaders([
                    'Accept' => 'application/json',
                    'Content-Type' => 'application/json'
                ])
                ->timeout(60) // Set timeout to 60 seconds
                ->post($url, $payload);

            if (!$response->successful()) {
                throw new \Exception("API request failed with status: " . $response->status());
            }

            $data = $response->json();

            // Check if we have the expected data structure
            if (!isset($data['Leads']) || !is_array($data['Leads'])) {
                throw new \Exception("Invalid API response structure");
            }

            $students = [];
            $now = now();

            foreach ($data['Leads'] as $lead) {
                if (!isset($lead['LeadPropertyList'])) {
                    continue; // Skip if no property list
                }

                $properties = collect($lead['LeadPropertyList'])
                    ->pluck('Value', 'Attribute')
                    ->toArray();

                // Format dates if needed
                $registrationDate = isset($properties['mx_Registration_On']) 
                    ? Carbon::parse($properties['mx_Registration_On']) 
                    : null;

                $dob = isset($properties['mx_DOB']) 
                    ? Carbon::parse($properties['mx_DOB']) 
                    : null;

                    $studentId = DB::table('student')->where('aaft_unique_id', $properties['ProspectID'])->pluck('student_id');

                    if($studentId != 0)
                    {
                        DB::table('student')->insert([
                        'school' => $properties['mx_Dummy_Dropdown_8'] ?? null,
                        'course' => $properties['mx_Dummy_Dropdown_9'] ?? null,
                        'program_type' => $properties['mx_Programme'] ?? null,
                        'program_duration' => $properties['mx_Duration'] ?? null,
                        'batch_code' => $properties['mx_Dummy_Text_21'] ?? null,
                        'registration_date' => strval($properties['mx_Registration_On']),
                        'batch' => $properties['mx_Batch'] ?? null,
                        'increemental_number' => null,
                        'full_name' => $properties['FirstName'] . ' ' . $properties['mx_Middle_Name'] . ' ' . $properties['LastName'],
                        'aaft_unique_id' => $properties['mx_Admission_Number'] ?? null,
                        'campus_email_id' => $properties['mx_Dummy_Text_25'] ?? null,
                        'first_name' => $properties['FirstName'] ?? null,
                        'last_name' => $properties['LastName'] ?? null,
                        'middle_name' => $properties['mx_Middle_Name'] ?? null,
                        'contact_number' => $properties['Phone'] ?? null,
                        'email' => $properties['EmailAddress'] ?? null,
                        'dob' => strval($properties['mx_DOB']),
                        'gender' => $properties['mx_Gender'] ?? null,
                        'blood_group' => $properties['mx_Blood_Group'] ?? null,
                        'nationality' => $properties['mx_Nationality'] ?? null,
                        'emergency_contact' => $properties['mx_Emergency_Contact_Number'] ?? null,
                        'curr_address1' => $properties['mx_Present_Address_Details'] ?? null,
                        'curr_address2' => null,
                        'curr_country' => $properties['mx_Dummy_Dropdown_2'] ?? null,
                        'curr_state' => $properties['mx_Dummy_Dropdown_4'] ?? null,
                        'curr_city' => null,
                        'curr_pincode' => $properties['mx_Present_Address_Zip_Code'] ?? null,
                        'perm_address1' => $properties['mx_Permanent_Address'] ?? null,
                        'perm_address2' => null,
                        'perm_country' => $properties['mx_Dummy_Dropdown_5'] ?? null,
                        'perm_state' => $properties['mx_Dummy_Dropdown_6'] ?? null,
                        'perm_city' => $properties['mx_Dummy_Dropdown_7'] ?? null,
                        'perm_pincode' => $properties['mx_Permanent_Address_Zip_Code'] ?? null,
                        'father_name' => $properties['mx_Parent_Guardian_Details_1'] ?? null,
                        'father_relationship' => null,
                        'father_nationality' => null,
                        'mother_name' => $properties['mx_Parent_Guardian_Details_2'] ?? null,
                        'mother_relationship' => null,
                        'mother_nationality' => null,
                        'loan_required' => $properties['mx_Loan'] ?? null,
                        'amount_paid_till_now' => strval($properties['mx_Total_Amount_paid_by_Student']) ?? null,
                        'total_fees' => strval($properties['mx_Number_Field_1']) ?? null,
                        'to_pay' => null,
                        'course_fee_balance' => null,
                        'difference' => null,
                        'mode_payment' => null,
                        'prospect_id' => $properties['ProspectID'],
                        'img_path' => null,
                        'img_name' => null,
                        'created_date' => now(),
                        'updated_date' => now(),
                        'completed_status' => 0,
                        'created_by' => 'idcard@aaft.com',
                        'updated_by' => 'idcard@aaft.com',
                        'active' => 1
                        ]);
                    }
                
                //DB::table('student')->insert($students);
            }
            // dd($students);
            // die();
            // // Batch insert for better performance
            //  if (!empty($students)) {
            //      DB::table('student')->insert($students);
            //  }

            return true;

        } catch (Exception $e) {
            // Log the error
            Log::error('Error in handle method: ' . $e->getMessage());
            
            // Optionally rethrow if you want to handle it elsewhere
            // throw $e;
            
            return false;
        }
    }
}
