<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Log;
use Exception;
use Illuminate\Support\Facades\RateLimiter;
use Illuminate\Support\Facades\Cache;
use Carbon\Carbon;

class UserController extends Controller
{
    public function Login(Request $req)
    {
        
            $email = $req->email;
            $password = $req->password;
            
            if($email == "idcard@aaft.com" && $password == "12345678")
            {
                session()->put('username', 'idcard@aaft.com');
                return response()->json(['loginMsg' => url("student-details")]); 
            }
            else if($email == "staff@aaft.com" && $password == "12345678")
            {
                session()->put('username', 'staff@aaft.com');
                return response()->json(['loginMsg' => url("staff-details")]);
            }
            else
            {
                return response()->json(['loginMsg' => "Invalid email"]);
            }
    }

    public function logout()
    {
        session()->flush();
        return view('sales_login');
    }

    public function studentDetails()
    {
        if(session()->has('username'))
        {            
            return view('student_details');
        }
        else
        {
            return view('sales_login');
        }
    }

    public function autocompleteStudentSearch(Request $request)
    {
        if(session()->has('username'))
        {
            $searchTerm = $request->input('term');
            $numericCheck = $request->input('numeric');
            // Here you would typically query your database for students matching the search term
            // For demonstration, let's assume we have a static array of students
            if ($numericCheck == 1)
            {
                $userList = DB::table('student')->select('contact_number','completed_status')->where('contact_number', 'LIKE', "%{$searchTerm}%")->get();
            }
            else if ($numericCheck == 0)
            {
                $userList = DB::table('student')->select('full_name','completed_status')->where('full_name', 'LIKE', "%{$searchTerm}%")->get();
                
            }
            
            return response()->json($userList);
        }
        else
        {
            return response()->json(['error' => 'Unauthorized'], 401);
        }
    }

    public function studentDetailsComplete(Request $request)
    {
        if(session()->has('username'))
        {
            $studentId = $request->input('student');
            // Here you would typically fetch the complete details of the student from the database
            // For demonstration, let's assume we have a static array of student details
            $studentDetails = DB::select("SELECT * FROM student s WHERE s.contact_number = ? or Upper(s.full_name) = ?", [$studentId, Str::upper($studentId)]);
            $courseCode = '';
            
            $stateList = DB::table('state')->select('state_name')->get();
            $currCityList = DB::table('city')->select('city_name')->get();
            $permCityList = DB::table('city')->select('city_name')->get();
            $courseList = DB::table('course')->select('course_name')->get();
            $schoolList = DB::table('school')->select('school_name')->get();
            $locationList[] = "Sector 5";
            $locationList[] = "Sector 16";
            $locationList[] = "University, Raipur";
            foreach($studentDetails as $student)
            {
                $courseCode = DB::table('course')->where('course_name', $student->course)->pluck('course_code');
            }
            
            return response()->json([
                'studentDetails' => $studentDetails,
                'stateList' => $stateList,
                'currCityList' => $currCityList,
                'permCityList' => $permCityList,
                'courseList' => $courseList,
                'schoolList' => $schoolList,
                'courseCode' => $courseCode,
                'locationList' => $locationList
            ]);

        }
        else
        {
            return response()->json(['error' => 'Unauthorized'], 401);
        }
    }

    public function getCity(Request $request)
    {
        if(session()->has('username'))
        {
            $stateName = $request->input('stateId');
            $cityList = DB::select("SELECT c.city_name FROM city c
                                        LEFT JOIN state s ON c.fk_state_id = s.state_id
                                        WHERE UPPER(s.state_name) = UPPER(?)", [$stateName]);
                
            return response()->json($cityList);
        }
        else
        {
            return response()->json(['error' => 'Unauthorized'], 401);
        }
    }

    public function submitStudentDetails(Request $req)
    {        
        $school = $req->school;
        $course = $req->course;
        $programType = $req->programType;
        $programDuration = $req->programDuration;
        $batch = $req->batch;
        $regDate = $req->regDate;
        // $totalCourseAmt = $req->totalCourseAmt;
        // $totalAmountPaidNow = $req->totalAmountPaidNow;
        // $toPay = $req->toPay;
        // $courseFeeBalance = $req->courseFeeBalance;
        // $difference = $req->difference;
        // $modeOfPayment = $req->modeOfPayment;    
        $uniqueId = $req->uniqueId;
        $campusEmailId = $req->campusEmailId;    
        $firstName = $req->firstName;
        $lastName = $req->lastName;
        $middleName = $req->middleName;
        $fullName = $firstName . " " . $middleName . " " . $lastName;
        $contactNumber = $req->contactNumber;
        $email = $req->email;
        $dob = $req->dob;
        $gender = $req->gender;
        $bloodGroup = $req->bloodGroup;
        // $nationality = $req->nationality;
        $emergencyContact = $req->emergencyContact;
        $currAddress1 = $req->currAddress1;
        $currAddress2 = $req->currAddress2;
        $currCountry = $req->currCountry;
        $currState = $req->currState;
        $currCity = $req->currCity;
        $currPinCode = $req->currPincode;
        $permAddress1 = $req->permAddress1;
        $permAddress2 = $req->permAddress2;
        $permCountry = $req->permCountry;
        $permState = $req->permState;
        $permCity = $req->permCity;
        $permPinCode = $req->permPincode;
        $imgName = $req->imgName;
        $imgPath = $req->imgPath;
        // $fatherName = $req->fatherName;
        // $fatherRelationship = $req->fatherRelationship;
        // $fatherNationality = $req->fatherNationality;
        // $motherName = $req->motherName;
        // $motherRelationship = $req->motherRelationship;
        // $motherNationality = $req->motherNationality;
        // $loanRequired = $req->loanRequired;
        $studentId = $req->studentId;
        $batchCode = '';
        $increementalNumber = $req->increementalNumber;
        // (float)$totalAmountPaidNow = (float)$totalAmountPaidNow + (float)$toPay;
        // (float)$courseFeeBalance = (float)$totalCourseAmt - (float)$totalAmountPaidNow;
        // if((float)$totalAmountPaidNow >= (float)$totalCourseAmt)
        // {
        //     (float)$difference = (float)$totalAmountPaidNow;
        // }
        // $completedStatus = (float)$courseFeeBalance == 0 ? 1 : 0;
        // (string)$toPay = '';
        $uniqueId =$req->uniqueId;
        $durationPeriod = '';
        if($batch == "Degree Batch - 2025")
        {
          $batchCode = "825";
          if($programDuration == "3 Years")
          {
            $durationPeriod = "August 2025 to July 2028";
          }
          else if($programDuration == "4 Years")
          {
            $durationPeriod = "August 2025 to July 2029";
          } 
        }
        else if($batch == "March 2025")
        {
          $batchCode = "124";
          if($programDuration == "1 Year")
          {
            $durationPeriod = "March 2025 to February 2026";
          }
          else if($programDuration == "3 Months")
          {
            $durationPeriod = "March 2025 to June 2025";
          }
          else if($programDuration == "6 Months")
          {
            $durationPeriod = "March 2025 to September 2025";
          }
        }
        else if($batch == "June 2025")
        {
          $batchCode = "125";
          if($programDuration == "1 Year")
          {
            $durationPeriod = "June 2025 to May 2026";
          }
          else if($programDuration == "3 Months")
          {
            $durationPeriod = "June 2025 to September 2025";
          }
          else if($programDuration == "6 Months")
          {
            $durationPeriod = "June 2025 to December 2025";
          }
        }
        else if($batch == "August 2025")
        {
          $batchCode = "126";
          if($programDuration == "1 Year")
          {
            $durationPeriod = "August 2025 to July 2026";
          }
          else if($programDuration == "3 Months")
          {
            $durationPeriod = "August 2025 to November 2025";
          }
          else if($programDuration == "6 Months")
          {
            $durationPeriod = "June 2025 to December 2025";
          }
        }
        else if($batch == "September 2025")
        {
          $batchCode = "127";
          if($programDuration == "1 Year")
          {
            $durationPeriod = "September 2025 to August 2026";
          }
          else if($programDuration == "3 Months")
          {
            $durationPeriod = "September 2025 to December 2025";
          }
          else if($programDuration == "6 Months")
          {
            $durationPeriod = "September 2025 to March 2026";
          }
        }
        else if($batch == "December 2025")
        {
          $batchCode = "128";
          if($programDuration == "1 Year")
          {
            $durationPeriod = "December 2025 to November 2026";
          }
          else if($programDuration == "3 Months")
          {
            $durationPeriod = "December 2025 to March 2026";
          }
          else if($programDuration == "6 Months")
          {
            $durationPeriod = "December 2025 to June 2026";
          }
        }

        DB::table('student')->where('student_id', $studentId)->update([
            'school' => $school,
            'course' => $course,
            'program_type' => $programType,
            'program_duration' => $programDuration,
            'batch' => $batch,
            'location' => $req->location,
            'registration_date' => $regDate,
            'batch_code' => $batchCode,
            'aaft_unique_id' => $uniqueId,
            'campus_email_id' => $campusEmailId,
            'first_name' => $firstName,
            'last_name' => $lastName,
            'middle_name' => $middleName,
            'full_name' => $fullName,
            'contact_number' => $contactNumber,
            'email' => $email,
            'dob' => strval($dob),
            'gender' => $gender,
            'blood_group' => $bloodGroup,
            //'nationality' => $nationality,
            'emergency_contact' => $emergencyContact,
            'curr_address1' => $currAddress1,
            'curr_address2' => $currAddress2,
            'curr_country' => $currCountry,
            'curr_state' => $currState,
            'curr_city' => $currCity,
            'curr_pincode' => strval($currPinCode),
            'perm_address1' => $permAddress1,
            'perm_address2' => $permAddress2,
            'perm_country' => $permCountry,
            'perm_state' => $permState,
            'perm_city' => $permCity,
            'perm_pincode' => strval($permPinCode),
            'img_name' => $imgName ?? null,
            'img_path' => $imgPath ?? null,
            // 'father_name' => $fatherName,
            // 'father_relationship' => $fatherRelationship,
            // 'father_nationality' => $fatherNationality,
            // 'mother_name' => $motherName,
            // 'mother_relationship' => $motherRelationship,
            // 'mother_nationality' => $motherNationality,
            // 'loan_required' => $loanRequired,
            // 'total_fees' => (string)$totalCourseAmt,
            // 'amount_paid_till_now' => (string)$totalAmountPaidNow,
            // 'to_pay' => (string)$toPay,
            // 'course_fee_balance' => (string)$courseFeeBalance,
            // 'difference' => (string)$difference,
            // 'mode_payment'=> $modeOfPayment,                      
            'completed_status' => 1,
            'updated_by' => session()->get('username'),
            'updated_date' => now(),
            'active' => 1
            ]);

            $schoolCode = DB::table('school')->where('school_name', $school)->pluck('school_code');

            DB::table('student_print')->delete();
            
            DB::table('student_print')->insert([
                'full_name' => $fullName,
                'email_addres' => $campusEmailId,
                'course_name' => $course,
                'unique_id' => $uniqueId,
                'school_code' => $schoolCode,
                'duration' => $durationPeriod,
                'contact_number' => $contactNumber,
                'emergency_contact' => $emergencyContact,
                'blood_group' => $bloodGroup,
                'home_address' => $currAddress1 . ", " . $currCity . ", " . $currState . ", " . strval($currPinCode),
                'dob' => strval($dob),
                'created_by' => session()->get('username'),
                'updated_by' => session()->get('username'),
                'created_date' => now(),
                'updated_date' => now(),
                'active' => 1
            ]);

        return response()->json(['success' => 'Student details updated successfully']);
    }

    public function printStudentDetails(Request $request)
    {
        $studentId = $request->input('studentId1');
        // Get student record
        $student = DB::table('student')->where('student_id', $studentId)->first();

        if (!$student) {
            return response()->json(['message' => 'Student not found'], 404);
        }

        // Check if not printed yet
        if ((int)$student->print_status !== 1) {
            // Update status
            DB::table('student')->where('student_id', $studentId)->update([
                'print_status' => 1,
                'updated_by' => session()->get('username'),
                'updated_date' => now()
            ]);

            // Run BAT file based on location
            if ($student->location === "Sector 5") {
                $command = 'start cmd.exe /k "D:\\cardpresso\\AAFT-Student-Sector-5.bat"';
                shell_exec($command);
            } elseif ($student->location === "Sector 16") {
                $command = 'start cmd.exe /k "D:\\cardpresso\\AAFT-Student-Sector-16.bat"';
                shell_exec($command);

            }

            return response()->json(['message' => 'Printed']);
        } else {
            return response()->json(['message' => 'ID card already printed']);
        }
    }

    public function runBatchFile()
    {
        $command = 'start "" "D:\\cardpresso\\card.bat"';
        shell_exec($command);
        return response()->json(['status' => 'Batch file executed']);
    }

    public function changeProgramRequest()
    {
        if(session()->has('username'))
        {
            $courseList = DB::table('course')->select('course_name')->get();
            return response()->json($courseList);
        }
        else
        {
            return view('sales_login');
        }
    }

    public function updateCourse(Request $req)
    {
        if(session()->has('username'))
        {
            $courseId = $req->updatedCourseId;
            $courseList = DB::select("SELECT c.course_name, c.total_course_fee, s.school_name, p.program_name, c.course_duration, c.course_code FROM course c
                                        LEFT JOIN school s ON s.school_id = c.fk_school_id
                                        LEFT JOIN program p ON p.program_id = c.fk_program_id
                                        WHERE c.course_name = ?", [$courseId]);
            return response()->json(['courseList' => $courseList]);
        }
        else
        {
            return view('sales_login');
        }
    }

    //Staff Section
    
    public function staffDetails(Request $req)
    {
        if(session()->has('username'))
        {            
            return view('staff_details');
        }
        else
        {
            return view('sales_login');
        }
    }

    public function getStaffDetails(Request $request)
    {
        try {
            $data = $request->getContent();

            // If data is still a string for some reason, decode it
            if (is_string($data)) {
                $data = json_decode($data, true);
            }

            // If still stringified, decode again
            while (is_string($data)) {
                $data = json_decode($data, true);
            }
            if (!is_array($data) || empty($data)) {
                return response()->json(['error' => 'Invalid or empty data provided'], 400);
            }           

            $timestamp = now();

            $insertData = [];
            //return response()->json(['message' => $data]);
            foreach ($data as $item) {

                // Check if employee already exists
                $existsEmpCode = DB::table('staff')->where('employee_code', $item['emp_code'])->exists();
                if ($existsEmpCode) {
                    return response()->json(['error' => 'Duplicate employee code'], 403);
                }

                $existsWorkEmail = DB::table('staff')->where('work_email', $item['work_email'])->exists();
                if ($existsWorkEmail) {
                    return response()->json(['error' => 'Duplicate work email'], 403);
                }
                
                $insertData[] = [
                    'employee_code'     => $item['emp_code'],
                    'full_name'         => $item['full_name'] ?? null,
                    'contact_number'    => $item['contact_number'] ?? null,
                    'emergency_number'  => $item['emergency_number'] ?? null,
                    'permanent_address' => $item['perm_address'] ?? null,
                    'perm_city'         => $item['perm_city'] ?? null,
                    'perm_state'        => $item['perm_state'] ?? null,
                    'perm_country'      => $item['perm_country'] ?? null,
                    'perm_pincode'      => $item['perm_pincode'] ?? null, 
                    'current_address'   => $item['curr_address'] ?? null,
                    'curr_city'         => $item['curr_city'] ?? null,
                    'curr_state'        => $item['curr_state'] ?? null,
                    'curr_country'      => $item['curr_country'] ?? null,
                    'curr_pincode'      => $item['curr_pincode'] ?? null,
                    'blood_group'       => $item['blood_group'] ?? null,
                    'department'        => $item['department'] ?? null,
                    'work_email'        => $item['work_email'] ?? null,
                    'location'          => $item['location'] ?? null,
                    'designation'       => $item['designation'] ?? null,
                    'img_name'          => null,
                    'img_path'          => null,
                    'details_status'    => 0,
                    'print_status'      => 0, 
                    'created_by'        => "System",
                    'updated_by'        => "System",
                    'created_date'      => $timestamp,
                    'updated_date'      => $timestamp,
                    'active'            => 1
                ];
            }

            if (!empty($insertData)) {
                DB::table('staff')->insert($insertData);
                return response()->json(['message' => 'Staff data saved successfully']);
            } else {
                return response()->json(['error' => 'No valid staff records to insert'], 400);
            }

        } catch (Throwable $ex) {
            Log::error('Exception in getStaffDetails', ['message' => $ex->getMessage()]);
            return response()->json(['error' => 'Something went wrong: ' . $ex->getMessage()], 500);
        }
    }


    public function autocompleteStaffSearch(Request $request)
    {
        if(session()->has('username'))
        {
            $searchTerm = $request->input('term');
            
            // Here you would typically query your database for students matching the search term
            // For demonstration, let's assume we have a static array of students
            $staffList = DB::table('staff')->select('full_name','print_status')->where('full_name', 'LIKE', "%{$searchTerm}%")->get();
            
            return response()->json($staffList);
        }
        else
        {
            return response()->json(['error' => 'Unauthorized'], 401);
        }
    }

    public function staffDetailsComplete(Request $request)
    {
        if(session()->has('username'))
        {
            $staffId = $request->input('staffName');
            // Here you would typically fetch the complete details of the student from the database
            // For demonstration, let's assume we have a static array of student details
            $staffDetails = DB::select("SELECT * FROM staff s WHERE Upper(s.full_name) = ?", [Str::upper($staffId)]);
            $courseCode = '';
            
            $stateList = DB::table('state')->select('state_name')->get();
            $currCityList = DB::table('city')->select('city_name')->get();
            $permCityList = DB::table('city')->select('city_name')->get();
            
            return response()->json([
                'staffDetails' => $staffDetails,
                'stateList' => $stateList,
                'currCityList' => $currCityList,
                'permCityList' => $permCityList
            ]);
        }
        else
        {
            return response()->json(['error' => 'Unauthorized'], 401);
        }
    }

    public function submitStaffDetails(Request $req)
    {
        if(session()->has('username'))
        {
            $staffId = $req->input('staffId');
            $currAddress = $req->currAddress;
            $currCity = $req->currState;
            $currState = $req->currCity;
            $currPincode = $req->currPincode;
            $permAddress = $req->permAddress;
            $permState = $req->permState;
            $permCity = $req->permCity;
            $permPincode = $req->permPincode;
            $location = $req->location;

            $staffPrint = DB::table('staff')->where('staff_id', $staffId)->pluck('print_status');            

            DB::table('staff')->where('staff_id', $staffId)->update([
                'current_address' => $currAddress,
                'curr_city' => $currCity,
                'curr_state' => $currState,
                'curr_pincode' => $currPincode ?? NULL,
                'permanent_address' => $permAddress,
                'perm_state' => $permState,
                'perm_city' => $permCity,
                'perm_pincode' => $permPincode,
                'location' => $location,
                'details_status' => 1,
                'updated_date' => now(),
                'updated_by' => session()->get('username')
            ]);
            //$fullName = $firstName . " " . $middleName . " " . $lastName;
            $permanentAddress = $permAddress . ", " . $permCity . ", " . $permState . ", " . $permPincode;
            $currentAddress = $currAddress . ", " . $currCity . ", " . $currState . ", " . $currPincode; 

            $staffList = DB::table('staff')->where('staff_id', $staffId)->get();
            foreach($staffList as $staff)
            {
                if($staff->print_status == 0)
                {
                DB::table('staff_print')->insert([
                    'emp_code' => $staff->employee_code,
                    'full_name' => $staff->full_name,
                    'contact_number' => $staff->contact_number,
                    'emergency_number' => $staff->emergency_number,
                    'perm_address' => $permanentAddress,
                    'curr_address' => $currentAddress,
                    'blood_group' => $staff->blood_group,
                    'department' => $staff->department,
                    'designation' => $staff->designation,
                    'location' => $staff->location,
                    'work_email' => $staff->work_email,
                    'created_by' => session()->get('username'),
                    'updated_by' => session()->get('username'),
                    'created_date' => now(),
                    'updated_date' => now(),
                    'active' => 1,
                ]);
                }
                else
                {
                    return response()->json(['message' => 'ID card printed']);
                }
            }
            return response()->json(['success' => 'success']);
        }
        else
        {
            return response()->json(['error' => 'Unauthorized'], 401);
        }
    }

    public function fetchLsqData()
    {
        $url = 'https://api-in21.leadsquared.com/v2/LeadManagement.svc/Leads/Retrieve/BySearchParameter?accessKey=u$rab774ce6190a55b000eda581cf924675&secretKey=a8cf026741d168af7a501e791490b314ece978ea';

        $payload = [
            "SearchParameters" => [
                "AdvancedSearchTextNew" => "{\"GrpConOp\":\"And\",\"Conditions\":[{\"Type\":\"Lead\",\"ConOp\":\"or\",\"RowCondition\":[{\"SubConOp\":\"And\",\"LSO\":\"mx_Dummy_Dropdown_1\",\"LSO_Type\":\"PickList\",\"Operator\":\"eq\",\"RSO\":\"Application Process Completed\",\"RSO_IsMailMerged\":false},{\"RSO\":\"\"},{\"RSO\":\"\"}]}],\"QueryTimeZone\":\"India Standard Time\"}",
                "Columns" => [
                    "Include_CSV" => "ProspectID,FirstName,LastName,EmailAddress,mx_Dummy_Dropdown_8,mx_Dummy_Dropdown_9,mx_Programme,mx_Duration,mx_Batch,mx_Registration_On,mx_Dummy_Text_21,mx_Admission_Number,mx_Dummy_Text_25,mx_Middle_Name,Phone,mx_DOB,mx_Gender,mx_Blood_Group,mx_Nationality,mx_Emergency_Contact_Number,mx_Permanent_Address,mx_Dummy_Dropdown_7,mx_Dummy_Dropdown_5,mx_Dummy_Dropdown_6,mx_Permanent_Address_Zip_Code,mx_Dummy_Dropdown_4,mx_Dummy_Dropdown_2,mx_Present_Address_Details,mx_Dummy_Dropdown_3,mx_Present_Address_Zip_Code,mx_Fathers_Name,mx_Mothers_Name,mx_Parent_Guardian_Details_1,mx_Parent_Guardian_Details_2,mx_Loan,mx_Number_Field_1,mx_Total_Amount_paid_by_Student"
                ],
                "EntityType" => 1,
                "Paging" => [
                    "PageIndex" => 1,
                    "PageSize" => 1000
                ],
                "DefinitionType" => "1"
            ]
        ];

        try {
            $response = Http::withHeaders([
                    'Accept' => 'application/json',
                    'Content-Type' => 'application/json'
                ])
                ->timeout(60) // Set timeout to 60 seconds
                ->post($url, $payload);

            if (!$response->successful()) {
                throw new Exception("API request failed with status: " . $response->status());
            }

            $data = $response->json();

            // Check if we have the expected data structure
            if (!isset($data['Leads']) || !is_array($data['Leads'])) {
                throw new Exception("Invalid API response structure");
            }

            $students = [];
            $now = now();

            foreach ($data['Leads'] as $lead) {
                if (!isset($lead['LeadPropertyList'])) {
                    continue; // Skip if no property list
                }

                $properties = collect($lead['LeadPropertyList'])
                    ->pluck('Value', 'Attribute')
                    ->toArray();

                // Format dates if needed
                $registrationDate = isset($properties['mx_Registration_On']) 
                    ? Carbon::parse($properties['mx_Registration_On']) 
                    : null;

                $dob = isset($properties['mx_DOB']) 
                    ? Carbon::parse($properties['mx_DOB']) 
                    : null;

                    DB::table('student')->insert([
                    'school' => $properties['mx_Dummy_Dropdown_8'] ?? null,
                    'course' => $properties['mx_Dummy_Dropdown_9'] ?? null,
                    'program_type' => $properties['mx_Programme'] ?? null,
                    'program_duration' => $properties['mx_Duration'] ?? null,
                    'batch_code' => $properties['mx_Dummy_Text_21'] ?? null,
                    'registration_date' => strval($properties['mx_Registration_On']),
                    'batch' => $properties['mx_Batch'] ?? null,
                    'increemental_number' => null,
                    'full_name' => $properties['FirstName'] . ' ' . $properties['mx_Middle_Name'] . ' ' . $properties['LastName'],
                    'aaft_unique_id' => $properties['mx_Admission_Number'] ?? null,
                    'campus_email_id' => $properties['mx_Dummy_Text_25'] ?? null,
                    'first_name' => $properties['FirstName'] ?? null,
                    'last_name' => $properties['LastName'] ?? null,
                    'middle_name' => $properties['mx_Middle_Name'] ?? null,
                    'contact_number' => $properties['Phone'] ?? null,
                    'email' => $properties['EmailAddress'] ?? null,
                    'dob' => strval($properties['mx_DOB']),
                    'gender' => $properties['mx_Gender'] ?? null,
                    'blood_group' => $properties['mx_Blood_Group'] ?? null,
                    'nationality' => $properties['mx_Nationality'] ?? null,
                    'emergency_contact' => $properties['mx_Emergency_Contact_Number'] ?? null,
                    'curr_address1' => $properties['mx_Present_Address_Details'] ?? null,
                    'curr_address2' => null,
                    'curr_country' => $properties['mx_Dummy_Dropdown_2'] ?? null,
                    'curr_state' => $properties['mx_Dummy_Dropdown_4'] ?? null,
                    'curr_city' => null,
                    'curr_pincode' => $properties['mx_Present_Address_Zip_Code'] ?? null,
                    'perm_address1' => $properties['mx_Permanent_Address'] ?? null,
                    'perm_address2' => null,
                    'perm_country' => $properties['mx_Dummy_Dropdown_5'] ?? null,
                    'perm_state' => $properties['mx_Dummy_Dropdown_6'] ?? null,
                    'perm_city' => $properties['mx_Dummy_Dropdown_7'] ?? null,
                    'perm_pincode' => $properties['mx_Permanent_Address_Zip_Code'] ?? null,
                    'father_name' => $properties['mx_Parent_Guardian_Details_1'] ?? null,
                    'father_relationship' => null,
                    'father_nationality' => null,
                    'mother_name' => $properties['mx_Parent_Guardian_Details_2'] ?? null,
                    'mother_relationship' => null,
                    'mother_nationality' => null,
                    'loan_required' => $properties['mx_Loan'] ?? null,
                    'amount_paid_till_now' => strval($properties['mx_Total_Amount_paid_by_Student']) ?? null,
                    'total_fees' => strval($properties['mx_Number_Field_1']) ?? null,
                    'to_pay' => null,
                    'course_fee_balance' => null,
                    'difference' => null,
                    'mode_payment' => null,
                    'prospect_id' => $properties['ProspectID'],
                    'img_path' => null,
                    'img_name' => null,
                    'created_date' => now(),
                    'updated_date' => now(),
                    'completed_status' => 0,
                    'created_by' => 'idcard@aaft.com',
                    'updated_by' => 'idcard@aaft.com',
                    'active' => 1
                ]);
                
                //DB::table('student')->insert($students);
            }
            // dd($students);
            // die();
            // // Batch insert for better performance
            //  if (!empty($students)) {
            //      DB::table('student')->insert($students);
            //  }

            return true;

        } catch (Exception $e) {
            // Log the error
            Log::error('Error in handle method: ' . $e->getMessage());
            
            // Optionally rethrow if you want to handle it elsewhere
            // throw $e;
            
            return false;
        }
    }

}
