<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;
use Illuminate\Support\Facades\Log;

class VerifyStaffApiKey
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        $providedKey = $request->header('idcard-access-key');
        $expectedKey = env('STAFF_ACCESS_KEY');

        Log::info('Provided API Key:', [$request->header('idcard-access-key')]);
        Log::info('Expected API Key:', [env('STAFF_ACCESS_KEY')]);

        if ($providedKey !== $expectedKey) {
            return response()->json(['error' => 'Unauthorized Access'], 401);
        }
        return $next($request);
    }
}
