<!DOCTYPE html>
<html lang="en">
    <head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <title>AAFT Admission Services - Capture Picture</title>
    <script src="https://cdn.tailwindcss.com"></script>
    </head>
    <body class="bg-pink-50">
        <!-- Header -->
        <div class="bg-black flex flex-col sm:flex-row justify-between items-center p-4">
        <img src="Aaft.png" alt="AAFT Logo" class="h-12 mb-2 sm:mb-0">
        <h1 class="text-white text-lg font-bold">AAFT Admission Services</h1>
        <img src="Asms.png" alt="ASMS Logo" class="h-12 mt-2 sm:mt-0">
        </div>
        <!-- Main Content -->
        <div class="flex flex-col items-center justify-center mt-20">
        <!-- Profile Image with camera icon -->
        <div class="relative">
            <img id="profileImage" src="Photo.png" alt="Profile" class="w-48 h-48 rounded-full border-4 border-gray-300 object-scale-down">
            <button id="openCameraBtn" class="absolute bottom-2 right-2 bg-gray-200 p-2 rounded-full">
            <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 text-black" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 7h4l2-3h6l2 3h4v13H3V7z" />
            </svg>
            </button>
        </div>
        <!-- Buttons -->
        <div class="mt-6 flex space-x-4">
            <button id="saveBtn" class="bg-black text-white px-8 py-2 rounded hover:bg-red-600">Save</button>
            <button id="retakeBtn" class="bg-gray-300 text-black px-8 py-2 rounded">Retake</button>
        </div>
        </div>
        <!-- Camera Modal -->
        <div id="cameraModal" class="fixed inset-0 bg-black bg-opacity-75 flex items-center justify-center hidden">
            <div class="bg-white p-4 rounded">
                <video id="video" width="320" height="240" autoplay class="border"></video>
                <div class="flex justify-center mt-4">
                <button id="captureBtn" class="bg-black text-white px-4 py-2 rounded hover:bg-red-600">Capture</button>
                <button id="closeCameraBtn" class="ml-4 bg-gray-300 text-black px-4 py-2 rounded">Close</button>
                </div>
            </div>
        </div>
    </body>
    <script>
    let stream;
    // Initialize camera on page load
    window.addEventListener('load', function() {
    navigator.mediaDevices.getUserMedia({ video: true })
    .then(function(s) {
        stream = s;
        document.getElementById('video').srcObject = stream;
    })
    .catch(function(err) {
        alert("Camera not accessible: " + err);
    });
    });
    // Open camera modal without re-requesting permission
    document.getElementById('openCameraBtn').addEventListener('click', function() {
    document.getElementById('cameraModal').classList.remove('hidden');
    });
    // Capture image from video
    document.getElementById('captureBtn').addEventListener('click', function() {
    const video = document.getElementById('video');
    const canvas = document.createElement('canvas');
    canvas.width = video.videoWidth;
    canvas.height = video.videoHeight;
    const ctx = canvas.getContext('2d');
    ctx.drawImage(video, 0, 0, canvas.width, canvas.height);
    // Set captured image as profile image
    document.getElementById('profileImage').src = canvas.toDataURL('image/png');
    document.getElementById('cameraModal').classList.add('hidden');
    });
    // Close camera modal without stopping stream
    document.getElementById('closeCameraBtn').addEventListener('click', function() {
    document.getElementById('cameraModal').classList.add('hidden');
    });
    // Retake image: reset to placeholder and reopen camera modal
    document.getElementById('retakeBtn').addEventListener('click', function() {
    document.getElementById('profileImage').src = "Photo.png";
    document.getElementById('cameraModal').classList.remove('hidden');
    });
    // Save image (download to local)
    document.getElementById('saveBtn').addEventListener('click', function() {
    const image = document.getElementById('profileImage').src;
    // Check if image is captured (not placeholder)
    if(image.includes('Photo.png')){
        alert("No image captured to save.");
        return;
    }
    // Create a download link
    const link = document.createElement('a');
    link.href = image;
    link.download = 'student_image_' + Date.now() + '.png';
    document.body.appendChild(link);
    link.click();
    document.body.removeChild(link);
    });
    // Stop camera stream when user leaves page
    window.addEventListener('beforeunload', function() {
    if (stream) {
        stream.getTracks().forEach(track => track.stop());
    }
    });
    </script>
    </body>
</html>
