<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0" />
  <title>AAFT Admission Services</title>
  <script src="https://cdn.tailwindcss.com"></script>
  <script src="https://ajax.googleapis.com/ajax/libs/jquery/1.9.1/jquery.js"></script>
  <link href="https://code.jquery.com/ui/1.10.2/themes/smoothness/jquery-ui.css" rel="Stylesheet">
  <script src="https://code.jquery.com/ui/1.10.2/jquery-ui.js" ></script>
</head>
<body class="bg-gray-100">

<!-- Top Logo Bar -->
<div class="bg-white flex flex-col sm:flex-row justify-between items-center p-4 border-b">
  <img src="{{url('/images/Aaft.png')}}" alt="AAFT Logo" class="h-12 mb-2 sm:mb-0">
  <img src="{{url('/images/Asms.png')}}" alt="ASMS Logo" class="h-12 mt-2 sm:mt-0">
</div>

<!-- AAFT Admission Services Title & Search -->
<div class="bg-black">
  <div class="max-w-6xl mx-auto flex flex-col lg:flex-row justify-between items-center px-4 py-4">
    <h1 class="text-white text-xl font-bold mb-2 lg:mb-0">AAFT ID Card (Staff)</h1>

    <div class="flex items-center w-full lg:w-auto">
      <!-- Search input + button -->
      <div class="flex w-full lg:w-80">
        <input type="text" placeholder="Search by Name or Contact" id="staffSearch" 
               class="px-4 py-2 rounded-l border focus:outline-none w-full">
        <button id="searchButton" class="bg-red-600 text-white px-4 py-2 rounded-r hover:bg-red-700">
          Search
        </button>
      </div>

      <!-- Logout icon button -->
      <button id="logoutButton" class="ml-4">
        <a href="/logout"><img src="/images/logo.png" alt="Logout" class="h-8 w-8"></a>
      </button>
    </div>

  </div>
</div>

<!-- Placeholder Image (shown before any data is loaded) -->
<div id="placeholderImage" class="flex justify-center items-center py-10 bg-gray-100">
  <img src="/images/bgimage.gif" alt="Waiting for search" class="h-64 object-contain">
</div>

<script>
  document.getElementById('searchButton').addEventListener('click', function () {
    document.getElementById('placeholderImage').style.display = 'none';
    // Continue with search logic...
  });
</script>



<!-- Basic Details -->
<div class="max-w-6xl mx-auto bg-white mt-6 rounded shadow" id="academicDetails">
  <!-- Dark red header -->
  <h2 class="text-lg font-bold text-white bg-red-600 px-4 py-2 rounded-t">Basic Details</h2>

  <div class="p-4 grid grid-cols-1 lg:grid-cols-3 gap-4">

    <!-- Left form section -->
    <div class="lg:col-span-2 grid grid-cols-1 sm:grid-cols-2 gap-4">
      <input type="hidden" id="hdnStaffId" />
      <input type="hidden" id="hdnImageName" />
      <input type="hidden" id="hdnImagePath"  />


      <!-- Employee Code -->
      <div>
        <label class="block text-gray-700 mb-1">Employee Code</label>
        <input type="text" class="w-full border rounded px-3 py-2 bg-gray-200 text-gray-500" id="empCode" readonly >
      </div>

      <!-- Full Name -->
      <div>
        <label class="block text-gray-700 mb-1">Full Name</label>
        <input type="text" class="w-full border rounded px-3 py-2 bg-gray-200 text-gray-500" readonly id="fullName">
      </div>

      <!-- Contact Number -->
      <div>
        <label class="block text-gray-700 mb-1">Contact Number</label>
        <input type="text" class="w-full border rounded px-3 py-2 bg-gray-200 text-gray-500" readonly id="contactNumber">
      </div>

      <!-- Emergency Contact -->
      <div>
        <label class="block text-gray-700 mb-1">Emergency Contact</label>
        <input type="text" class="w-full border rounded px-3 py-2 bg-gray-200 text-gray-500" readonly id="emergencyContact">
      </div>

      <!-- Department -->
      <div>
        <label class="block text-gray-700 mb-1">Department</label>
        <input type="text" class="w-full border rounded px-3 py-2 bg-gray-200 text-gray-500" readonly id="department">
      </div>

      <!-- Designation -->
      <div>
        <label class="block text-gray-700 mb-1">Designation</label>
        <input type="text" class="w-full border rounded px-3 py-2 bg-gray-200 text-gray-500" readonly id="designation">
      </div>

      <!-- Work Email -->
      <div>
        <label class="block text-gray-700 mb-1">Work Email</label>
        <input type="text" class="w-full border rounded px-3 py-2 bg-gray-200 text-gray-500" readonly id="workEmail">
      </div>

      <!-- Blood Group -->
      <div>
        <label class="block text-gray-700 mb-1">Blood Group</label>
        <select class="w-full border rounded px-3 py-2 bg-gray-200 text-gray-500" id="bloodGroup">
        <option value="">--Select Blood Group--</option>
        <option value="A+">A+</option>
        <option value="A-">A-</option>
        <option value="B+">B+</option>
        <option value="B-">B-</option>
        <option value="AB+">AB+</option>
        <option value="AB-">AB+</option>
        <option value="O+">O+</option>
        <option value="O-">O-</option>
        </select>
      </div>
      <!-- Location -->
       <div>
       <label class="block text-gray-700 mb-1">Location</label>
       <select name="location" id="location" class="w-full border rounded px-3 py-2">
        <option value="">--Select--</option>
        <option value="Sector 5">Sector 5</option>
        <option value="Sector 16">Sector 16</option>
        <option value="Online Gurgaon">Online Gurgaon</option>
       </select>
       <span class="text-red-600" id="locationError" style="font-size: 12px;"></span>
       </div>
    </div>

    <!-- Right capture picture box -->
    <div class="flex justify-center items-center border rounded p-4">
      <div class="flex flex-col items-center">
        <img src="/images/Profile.png" alt="Captured Image" class="h-32 w-32 object-cover rounded mb-2">
        <button id="openModal" class="px-4 py-2 rounded hover:bg-red-600 bg-red-500 text-white">Capture Picture</button>
      </div>
    </div>

  </div>
</div>




<div class="max-w-6xl mx-auto bg-white mt-6 rounded shadow" id="personalDetails">
  <!-- Red header -->
  <h2 class="text-lg font-bold text-white bg-red-600 px-4 py-2 rounded-t">Address Details</h2>

  <div class="p-4 grid grid-cols-1 md:grid-cols-3 lg:grid-cols-4 gap-4">


<!-- Address Line 1 (Current) -->
<div class="md:col-span-2">
  <label class="block text-gray-700 mb-1">Address Line 1*</label>
  <input type="text" id="currAddress1" name="currAddress1" maxlength="32" class="w-full border rounded px-3 py-2" oninput="validateLength(this, 'currAddress1Error')" />
  <span class="text-red-600" id="currAddress1Error" style="font-size: 12px;"></span>
</div>

<!-- Address Line 2 (Current) -->
<div class="md:col-span-2">
  <label class="block text-gray-700 mb-1">Address Line 2*</label>
  <input type="text" id="currAddress2" name="currAddress2" maxlength="32" class="w-full border rounded px-3 py-2" oninput="validateLength(this, 'currAddress1Error')" />
  <span class="text-red-600" id="currAddress2Error" style="font-size: 12px;"></span>
</div>


    <!-- Country (Current) -->
    <div>
      <label class="block text-gray-700 mb-1">Country</label>
      <input type="text" id="currCountry" name="currCountry" class="w-full border rounded px-3 py-2" readonly>
    </div>

    <!-- State (Current) -->
    <div>
      <label class="block text-gray-700 mb-1">State*</label>
      <select name="currState" id="currState" onchange="getCity(1);" class="w-full border rounded px-3 py-2">
        <option value="">--Select State--</option>
      </select>
      <span class="text-red-600" id="currStateError" style="font-size: 12px;"></span>
    </div>

    <!-- City (Current) -->
    <div>
      <label class="block text-gray-700 mb-1">City*</label>
      <select name="currCity" id="currCity" class="w-full border rounded px-3 py-2">
        <option value="">--Select City--</option>
      </select>
      <span class="text-red-600" id="currCityError" style="font-size: 12px;"></span>
    </div>

    <!-- Pincode (Current) -->
    <div>
      <label class="block text-gray-700 mb-1">Pincode*</label>
      <input type="text" id="currPincode" name="currPincode" class="w-full border rounded px-3 py-2">
      <span class="text-red-600" id="currPincodeError" style="font-size: 12px;"></span>
    </div>

    <!-- Checkbox: Is Permanent Address same -->
    <div class="md:col-span-4">
      <label class="inline-flex items-center mt-2">
        <input type="checkbox" id="sameAddress" class="form-checkbox h-5 w-5 text-red-600">
        <span class="ml-2 text-red-700">Is your permanent address same as current address?</span>
      </label>
    </div>

    <!-- Permanent Address -->
    <div class="md:col-span-4">
      <h3 class="text-md font-semibold mb-2 mt-4">Permanent Address</h3>
    </div>

<!-- Address Line 1 (Permanant) -->
<div class="md:col-span-2">
  <label class="block text-gray-700 mb-1">Address Line 1*</label>
  <input type="text" id="permAddress1" name="permAddress1" maxlength="32" class="w-full border rounded px-3 py-2" oninput="validateLength(this, 'currAddress1Error')" />
  <span class="text-red-600" id="permAddress1Error" style="font-size: 12px;"></span>
</div>

<!-- Address Line 2 (Permanent) -->
<div class="md:col-span-2">
  <label class="block text-gray-700 mb-1">Address Line 2*</label>
  <input type="text" id="permAddress2" name="permAddress2" maxlength="32" class="w-full border rounded px-3 py-2" oninput="validateLength(this, 'currAddress1Error')" />
  <span class="text-red-600" id="permAddress2Error" style="font-size: 12px;"></span>
</div>


    <!-- Country (Permanent) -->
    <div>
      <label class="block text-gray-700 mb-1">Country</label>
      <input type="text" id="permCountry" name="permCountry" class="w-full border rounded px-3 py-2" readonly>
    </div>

    <!-- State (Permanent) -->
    <div>
      <label class="block text-gray-700 mb-1">State*</label>
      <select name="permState" id="permState" class="w-full border rounded px-3 py-2" onchange="getCity(0);">
        <option value="">--Select State--</option>
      </select>
      <span class="text-red-600" id="permStateError" style="font-size: 12px;"></span>
    </div>

    <!-- City (Permanent) -->
    <div>
      <label class="block text-gray-700 mb-1">City*</label>
      <select name="permCity" id="permCity" class="w-full border rounded px-3 py-2">
        <option value="">--Select City--</option>
      </select>
      <span class="text-red-600" id="permCityError" style="font-size: 12px;"></span>
    </div>

    <!-- Pincode (Permanent) -->
    <div>
      <label class="block text-gray-700 mb-1">Pincode*</label>
      <input type="text" id="permPincode" name="permPincode" class="w-full border rounded px-3 py-2">
      <span class="text-red-600" id="permPincodeError" style="font-size: 12px;"></span>
    </div>

  </div>
</div>
<!-- Save Button -->
 <!-- Save and Print Buttons in one row -->
<div class="max-w-6xl mx-auto text-center my-6 flex justify-center">
  <!-- Save Button -->
  <div id="saveButton" class="mr-4">
    <button class="bg-black text-white px-8 py-2 rounded hover:bg-red-600" id="saveStudentId" onclick="saveStudent()">Save</button>
  </div>

  <!-- Print Button -->
  <div id="printStaffButton">
    <button class="bg-black text-white px-8 py-2 rounded hover:bg-red-600" id="printStaffId" onclick="printStaff()">Print</button>
  </div>
</div>



<div id="myModal" class="hidden fixed inset-0 bg-gray-800 bg-opacity-50 flex items-center justify-center z-50">
    <!-- Modal content -->
    <div class="bg-white rounded-lg shadow-lg w-11/12 md:w-1/3 p-6">
      <h2 class="text-xl font-bold mb-4"></h2>
      <p class="mb-4">
	
	  	
		<!-- Main Content -->
		<div class="flex flex-col items-center justify-center mt-20">
		<!-- Profile Image with camera icon -->
		<div class="relative">
			<img id="profileImage" src="/images/Photo.png" alt="Profile" class="w-48 h-48 rounded-full border-4 border-gray-300 object-scale-down">
			<button id="openCameraBtn" class="absolute bottom-2 right-2 bg-gray-200 p-2 rounded-full">
			<svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 text-black" fill="none" viewBox="0 0 24 24" stroke="currentColor">
				<path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 7h4l2-3h6l2 3h4v13H3V7z" />
			</svg>
			</button>
		</div>
		<!-- Buttons -->
		<div class="mt-6 flex space-x-4">
			<button id="saveBtn" class="bg-black text-white px-8 py-2 rounded hover:bg-red-600">Save</button>
			<button id="retakeBtn" class="bg-gray-300 text-black px-8 py-2 rounded">Retake</button>
		</div>
		</div>
		<!-- Camera Modal -->
		<div id="cameraModal" class="fixed inset-0 bg-black bg-opacity-75 flex items-center justify-center hidden">
		<div class="bg-white p-4 rounded">
			<video id="video" width="320" height="240" autoplay class="border"></video>
			<div class="flex justify-center mt-4">
			<button id="captureBtn" class="bg-black text-white px-4 py-2 rounded hover:bg-red-600">Capture</button>
			<button id="closeCameraBtn" class="ml-4 bg-gray-300 text-black px-4 py-2 rounded">Close</button>
			</div>
		</div>
		</div>

	  </p>
      <div class="flex justify-end">
        <button id="closeModal" class="bg-red-500 text-white px-4 py-2 rounded hover:bg-red-600">
          Close
        </button>
      </div>
    </div>
  </div>

</body>

<!--  -->



<script>


var student_unique_id = '';

  function captureImage() {
    $("#imagehdnStudentId").val($("#studentId").val());
    $("#captureImageModal").modal('show');
  }

  

  let stream;
// Initialize camera on page load
window.addEventListener('load', function() {
  navigator.mediaDevices.getUserMedia({ video: true })
  .then(function(s) {
    stream = s;
    document.getElementById('video').srcObject = stream;
  })
  .catch(function(err) {
    alert("Camera not accessible: " + err);
  });
});
// Open camera modal without re-requesting permission
document.getElementById('openCameraBtn').addEventListener('click', function() {
  document.getElementById('cameraModal').classList.remove('hidden');
});
// Capture image from video
document.getElementById('captureBtn').addEventListener('click', function() {
  const video = document.getElementById('video');
  const canvas = document.createElement('canvas');
  canvas.width = video.videoWidth;
  canvas.height = video.videoHeight;
  const ctx = canvas.getContext('2d');
  ctx.drawImage(video, 0, 0, canvas.width, canvas.height);
  // Set captured image as profile image
  document.getElementById('profileImage').src = canvas.toDataURL('image/png');
  document.getElementById('cameraModal').classList.add('hidden');
});
// Close camera modal without stopping stream
document.getElementById('closeCameraBtn').addEventListener('click', function() {
  document.getElementById('cameraModal').classList.add('hidden');
});
// Retake image: reset to placeholder and reopen camera modal
document.getElementById('retakeBtn').addEventListener('click', function() {
  document.getElementById('profileImage').src = "Photo.png";
  document.getElementById('cameraModal').classList.remove('hidden');
});
// Save image (download to local)
document.getElementById('saveBtn').addEventListener('click', function() {
  const image = document.getElementById('profileImage').src;
  // Check if image is captured (not placeholder)
  if(image.includes('Photo.png')){
    alert("No image captured to save.");
    return;
  }
  // Create a download link
  const link = document.createElement('a');
  var programCode = '';
  const courseCode = $("#hdnCourseCode").val();
  const increementalNumber = $("#increemental_number").val();
  var batchCode = '';
  if($("#programType").val() == "Degree")
        {
            programCode = "UG";            
        }
        else if($("#programType").val() == "Diploma")
        {
            programCode = "DP";            
        }
        else if($("#programType").val() == "Certificate")
        {
            programCode = "CE";            
        }
        else if($("#programType").val() == "Post Graduate")
        {
            programCode = "PG";            
        }
        else if($("#programType").val() == "PG Diploma")
        {
            programCode = "PGDP";            
        }

        if($("#batch").val() == "Degree Batch - 2025")
        {
          batchCode = "825";
        }
        else if($("#batch").val() == "March 2025")
        {
          batchCode = "124";
        }
        else if($("#batch").val() == "June 2025")
        {
          batchCode = "125";
        }
        else if($("#batch").val() == "August 2025")
        {
          batchCode = "126";
        }
        else if($("#batch").val() == "September 2025")
        {
          batchCode = "127";
        }
        else if($("#batch").val() == "December 2025")
        {
          batchCode = "128";
        }
  link.href = image;
  
  student_unique_id = 'AN' + programCode + courseCode + batchCode + increementalNumber;
  link.download = student_unique_id + '.png';
  document.body.appendChild(link);
  link.click();
  document.body.removeChild(link);
});
// Stop camera stream when user leaves page
window.addEventListener('beforeunload', function() {
  if (stream) {
    stream.getTracks().forEach(track => track.stop());
  }
});


</script>

<!--  -->
<script>
    const modal = document.getElementById('myModal');
    const openModal = document.getElementById('openModal');
    const closeModal = document.getElementById('closeModal');
    openModal.addEventListener('click', () => {
      modal.classList.remove('hidden');
    });
    closeModal.addEventListener('click', () => {
      modal.classList.add('hidden');
    });
    window.addEventListener('click', (e) => {
      if (e.target == modal) {
        modal.classList.add('hidden');
      }
    });
  </script>

<script>
  // Initialize camera on page load
   function captureImage() {
    $("#imagehdnStudentId").val($("#studentId").val());
    $("#captureImageModal").modal('show');
  }
window.addEventListener('load', function() {
  navigator.mediaDevices.getUserMedia({ video: true })
  .then(function(s) {
    stream = s;
    document.getElementById('video').srcObject = stream;
  })
  .catch(function(err) {
    alert("Camera not accessible: " + err);
  });
});
// Open camera modal without re-requesting permission
document.getElementById('openCameraBtn').addEventListener('click', function() {
  document.getElementById('cameraModal').classList.remove('hidden');
});
// Capture image from video
document.getElementById('captureBtn').addEventListener('click', function() {
  const video = document.getElementById('video');
  const canvas = document.createElement('canvas');
  canvas.width = video.videoWidth;
  canvas.height = video.videoHeight;
  const ctx = canvas.getContext('2d');
  ctx.drawImage(video, 0, 0, canvas.width, canvas.height);
  // Set captured image as profile image
  document.getElementById('profileImage').src = canvas.toDataURL('image/png');
  document.getElementById('cameraModal').classList.add('hidden');
});
// Close camera modal without stopping stream
document.getElementById('closeCameraBtn').addEventListener('click', function() {
  document.getElementById('cameraModal').classList.add('hidden');
});
// Retake image: reset to placeholder and reopen camera modal
document.getElementById('retakeBtn').addEventListener('click', function() {
  document.getElementById('profileImage').src = "Photo.png";
  document.getElementById('cameraModal').classList.remove('hidden');
});
// Save image (download to local)
document.getElementById('saveBtn').addEventListener('click', function() {
  const image = document.getElementById('profileImage').src;
  // Check if image is captured (not placeholder)
  if(image.includes('Photo.png')){
    alert("No image captured to save.");
    return;

    
  }
  </script>

<script>
  document.getElementById('sameAddress').addEventListener('change', function() {
    const isChecked = this.checked;

    const fields = ['Address1', 'Address2', 'Country', 'State', 'City', 'Pincode'];
    fields.forEach(field => {
      const curr = document.getElementById('curr' + field);
      const perm = document.getElementById('perm' + field);
      if (isChecked) {
        perm.value = curr.value;
        perm.readOnly = true;
        perm.disabled = true;
        perm.classList.add('bg-gray-200', 'text-gray-500');
        if(perm.tagName === 'SELECT' || perm.tagName === 'TEXTAREA'){
          perm.disabled = true;
        }
      } else {
        perm.value = '';
        perm.readOnly = false;
        perm.disabled = false;
        perm.classList.remove('bg-gray-200', 'text-gray-500');
        if(perm.tagName === 'SELECT' || perm.tagName === 'TEXTAREA'){
          perm.disabled = false;
        }
      }
    });
  });

  $(document).ready(function () { 
    $("#academicDetails").hide();
    $("#personalDetails").hide();
    $("#saveStudentId").hide();
    $("#printStaffButton").hide();

    $('#staffSearch').autocomplete({
        source: function (request, response) {            

            $.ajax({
                url: "/autocomplete-staff-search",
                type: "GET",
                data: { term: request.term},
                success: function (data) {
                    const formatted = data.map(item => ({
                        label: item.full_name,
                        value: item.full_name,
                        status: item.details_status
                    }));
                    response(formatted);
                }
            });
        },
        minLength: 2
    }).data("ui-autocomplete")._renderItem = function (ul, item) {
        const tick = item.status == 1 ? '<span style="color:green;">&#10004;</span>' : '';
        return $("<li>")
            .append(`<div style="display:flex; justify-content:space-between;">${item.label} ${tick}</div>`)
            .appendTo(ul);
    };
  });

  $("#staffSearch").focusout(function(){
    var staffName = $("#staffSearch").val();
    $.ajax({
      url: '/staff-details-complete',
      type: 'GET',
      data: { staffName: staffName },
      success: function(data) {
        debugger;
        if (data.staffDetails.length > 0) {
          $("#academicDetails").show();
          $("#personalDetails").show();
          $("#saveStudentId").show();
          var currstateId = $("#currState").empty();
          var permstateId = $("#permState").empty();
          currstateId.append('<option value="">--Select State--</option>');
          permstateId.append('<option value="">--Select State--</option>');

          for(var i=0; i < data.stateList.length > 0; i++)
          {
              var city_item_el = '<option value="' + data.stateList[i]['state_name']+'">'+ data.stateList[i]['state_name']+'</option>';
              currstateId.append(city_item_el);
              permstateId.append(city_item_el);
          }

          var currCityId = $("#currCity").empty();
          var permCityId = $("#permCity").empty();
          currCityId.append('<option value="">--Select City--</option>');
          permCityId.append('<option value="">--Select City--</option>');

          for(var i=0; i < data.currCityList.length > 0; i++)
          {
              var city_item_el = '<option value="' + data.currCityList[i]['city_name']+'">'+ data.currCityList[i]['city_name']+'</option>';
              currCityId.append(city_item_el);
              permCityId.append(city_item_el);
          }
          $("#hdnStaffId").val(data.staffDetails[0].staff_id);
          $("#empCode").val(data.staffDetails[0].employee_code);
          $("#fullName").val(data.staffDetails[0].full_name);
          $("#contactNumber").val(data.staffDetails[0].contact_number);
          $("#emergencyContact").val(data.staffDetails[0].emergency_number);
          $("#department").val(data.staffDetails[0].department);
          $("#designation").val(data.staffDetails[0].designation);
          $("#workEmail").val(data.staffDetails[0].work_email);
          $("#bloodGroup").val(data.staffDetails[0].blood_group);          
          $("#currAddress1").val(data.staffDetails[0].current_address);    
          $("#currCountry").val(data.staffDetails[0].curr_country);
          $("#currState").val(data.staffDetails[0].curr_state);
          $("#currCity").val(data.staffDetails[0].curr_city);
          $("#currPincode").val(data.staffDetails[0].curr_pincode);
          $("#permAddress1").val(data.staffDetails[0].permanent_address);          
          $("#permCountry").val(data.staffDetails[0].perm_country);
          $("#permState").val(data.staffDetails[0].perm_state);
          $("#permCity").val(data.staffDetails[0].perm_city);
          $("#permPincode").val(data.staffDetails[0].perm_pincode);
          $("#location").val(data.staffDetails[0].location);                    
        } else {
          alert('No staff found with that name or contact');
        }
      },
      error: function() {
        alert('Error fetching student details');
      }
    });
  });

  function getCity(id) {
    if(id == 1){
        var stateId = $("#currState").val();
    } else {
        var stateId = $("#permState").val();
    }        
             
        $.ajax({
            type: "GET",
            url: "/get-city",
            data: { stateId: stateId },
            success: function(data) {
              debugger;
                if(data.length > 0) {
                if(id == 1){
                    var cityId = $("#currCity").empty();
                } else {
                    var cityId = $("#permCity").empty();
                }                   
                    
                    cityId.append('<option selected="selected" value="">--Select City--</option>');
                    for(var i = 0; i < data.length;i++){
                        var city_item_el = '<option value="' + data[i]['city_name']+'">'+ data[i]['city_name']+'</option>';
                        cityId.append(city_item_el);
                    }
                }
            }
        });
    }

    function saveStudent()
    {    
      debugger;  
      var currAddress = $("#currAddress1").val();
      var currAddress2 = $("#currAddress2").val();
      var currCity = $("#currCity").val();
      var currState = $("#currState").val();
      var currPincode = $("#currPincode").val();
      var permAddress = $("#permAddress1").val();
      var permAddress2 = $("#permAddress2").val();
      var permCity = $("#permState").val();
      var perState1 = $("#permCity").val();
      var permPincode = $("#permPincode").val();
      var location = $("#location").val();
      if(currAddress == "" || currAddress == null) {
        $("#currAddress1Error").empty().html("Please enter the current address line 1");
      }
      else {
        $("#currAddress1Error").empty().html("");
      }

      if(currState == "" || currState == null) {
        $("#currStateError").empty().html("Please select the current state");
      }
      else {
        $("#currStateError").empty().html("");
      }

      if(currCity == "" || currCity == null) {
        $("#currCityError").empty().html("Please select the current city");
      }
      else {
        $("#currCityError").empty().html("");
      }

      if(currPincode == "" || currPincode == null) {
        $("#currPincodeError").empty().html("Please enter the current pincode");
      }
      else {
        $("#currPincodeError").empty().html("");
      }

      if(permAddress == "" || permAddress == null) {
        $("#permAddress1Error").empty().html("Please enter the permanent address line 1");
      }
      else {
        $("#permAddress1Error").empty().html("");
      }

      if(permState == "" || permState == null) {
        $("#permStateError").empty().html("Please select the permanent state");
      }
      else {
        $("#permStateError").empty().html("");
      }

      if(permCity == "" || permCity == null) {
        $("#permCityError").empty().html("Please select the permanent city");
      }
      else {
        $("#permCityError").empty().html("");
      }

      if(permPincode == "" || permPincode == null) {
        $("#permPincodeError").empty().html("Please enter the permanent pincode");
      }
      else {
        $("#permPincodeError").empty().html("");
      }

      if(location == "" || location == null) {
        $("#locationError").empty().html("Please select location");
      }
      else {
        $("#locationError").empty().html("");
      }

      if($("#currAddress1Error").text() != "" || $("#currStateError").text() != "" ||
       $("#currCityError").text() != "" || $("#currPincodeError").text() != "" ||
       $("#permAddress1Error").text() != "" || $("#permStateError").text() != "" ||
       $("#permCityError").text() != "" || $("#permPincodeError").text() != "" || $("#locationError").text() != "") {
        return false;
      }
      else {
        currAddress = currAddress + " " + currAddress2;
        permAddress = permAddress + " " + permAddress2;
        let formData = new FormData();
        formData.append('staffId', $("#hdnStaffId").val())
        formData.append('currAddress', currAddress);        
        formData.append('currState', currState);
        formData.append('currCity', currCity);
        formData.append('currPincode', currPincode);
        formData.append('permAddress', permAddress);        
        formData.append('permState', perState1);
        formData.append('permCity', permCity);
        formData.append('permPincode', permPincode);
        formData.append('location', location);

        formData.append('_token', '{{ csrf_token() }}');
        $.ajax({
            type: "POST",
            url: "{{  url('/submit-staff-details') }}",
            data: formData,
            contentType: false,
            processData: false,
            success: function(response) {
              
                if(response.success == "success") {
                    alert("Staff details updated successfully.");
                    $("#printStaffButton").show();
                }
                else if(response.message == "ID card printed") {
                  alert("ID card is already printed, please contact admin for any changes.");
                }
                else {
                    alert("Error updating staff details: " + response.message);
                }
            }
        });
      }

    }

    function printStaff()
    {
      var imgName = $("#hdnImageName").val();
      var imgPath = $("#hdnImagePath").val();

      if(imgName == "") {
        alert("Please capture the image");
        return;
      }
      else {
        $.ajax({
            type: "POST",
            url: "{{  url('/print-staff-details') }}",
            data: formData,
            contentType: false,
            processData: false,
            success: function(response) {
              
                if(response.success == "success") {
                    alert("Staff details updated successfully.");
                    $("#printStaffButton").show();
                }
                else if(response.message == "ID card printed") {
                  alert("ID card is already printed, please contact admin for any changes.");
                }
                else {
                    alert("Error updating staff details: " + response.message);
                }
            }
        });
      }
    }


</script>




//5ay
