<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0" />
  <title>AAFT Admission Services</title>
  <script src="https://cdn.tailwindcss.com"></script>
  <script src="https://ajax.googleapis.com/ajax/libs/jquery/1.9.1/jquery.js"></script>
  <link href="https://code.jquery.com/ui/1.10.2/themes/smoothness/jquery-ui.css" rel="Stylesheet">
  <script src="https://code.jquery.com/ui/1.10.2/jquery-ui.js" ></script>
</head>
<body class="bg-gray-100">

<!-- Top Logo Bar -->
<div class="bg-white flex flex-col sm:flex-row justify-between items-center p-4 border-b">
  <img src="{{url('/images/Aaft.png')}}" alt="AAFT Logo" class="h-12 mb-2 sm:mb-0">
  <img src="{{url('/images/Asms.png')}}" alt="ASMS Logo" class="h-12 mt-2 sm:mt-0">
</div>

<!-- AAFT Admission Services Title & Search -->
<div class="bg-black">
  <div class="max-w-6xl mx-auto flex flex-col lg:flex-row justify-between items-center px-4 py-4">
    <h1 class="text-white text-xl font-bold mb-2 lg:mb-0">AAFT ID Card (Student)</h1>

    <div class="flex items-center w-full lg:w-auto">
      <!-- Search input + button -->
      <div class="flex w-full lg:w-80">
        <input type="text" placeholder="Search by Name or Contact" id="studentSearch" 
               class="px-4 py-2 rounded-l border focus:outline-none w-full">
        <button id="searchButton" class="bg-red-600 text-white px-4 py-2 rounded-r hover:bg-red-700">
          Search
        </button>
      </div>

      <!-- Logout icon button -->
      <button id="logoutButton" class="ml-4">
        <img src="/images/logo.png" alt="Logout" class="h-8 w-8">
      </button>
    </div>
    
  </div>
</div>

<!-- Placeholder Image (shown before any data is loaded) -->
<div id="placeholderImage" class="flex justify-center items-center py-10 bg-gray-100">
  <img src="/images/bgimage.gif" alt="Waiting for search" class="h-64 object-contain">
</div>

<script>
  document.getElementById('searchButton').addEventListener('click', function () {
    document.getElementById('placeholderImage').style.display = 'none';
    // Continue with search logic...
  });
</script>


<!-- Academic Details -->
<div class="max-w-6xl mx-auto bg-white mt-6 rounded shadow" id="academicDetails">
  <!-- Dark red strip -->
  <h2 class="text-lg font-bold text-white bg-red-600 px-4 py-2 rounded-t">Academics Details</h2>

  <div class="p-4 grid grid-cols-1 lg:grid-cols-3 gap-4">

    <!-- Left academic inputs (span 2 columns) -->
    <div class="lg:col-span-2 grid grid-cols-1 sm:grid-cols-2 gap-4">

      <!-- Select School -->
      <div>
        <input type="hidden" id="studentId" name="studentId" />
        <input type="hidden" id="prospect_id" name="prospect_id" />
        <input type="hidden" id="hdnCourseCode" name="hdnCourseCode" />
        <label class="block text-gray-700 mb-1">Select School</label>
        <input type="text" id="school" name="school" class="w-full border rounded px-3 py-2 bg-gray-200 text-gray-500" readonly>
        
      </div>

      <!-- Select Course -->
      <div>
        <label class="block text-gray-700 mb-1">Select Course</label>
        <input type="text" id="course" name="course" class="w-full border rounded px-3 py-2 bg-gray-200 text-gray-500" readonly>
        
      </div>

      <!-- Program Type -->
      <div>
        <label class="block text-gray-700 mb-1">Program Type</label>
        <input type="text" id="programType" name="programType" class="w-full border rounded px-3 py-2 bg-gray-200 text-gray-500" readonly>
      </div>

      <!-- Program Duration -->
      <div>
        <label class="block text-gray-700 mb-1">Program Duration*</label>
        <input type="text" id="programDuration" name="programDuration" class="w-full border rounded px-3 py-2 bg-gray-200 text-gray-500" readonly>
      </div>

      <!-- Change Program Request -->
       <a id="programRequestId" onclick="changeProgramRequest()" class="text-blue-600 hover:underline">Change Program Request</a>
      <div class="relative" id="changeProgramRequest" style="display:none;">
        <label class="block text-gray-700 mb-1">Change Program Request</label>
        <select id="changedCourseId" name="changedCourseId" onchange="updateCourse()" class="w-full border rounded px-3 py-2 pr-10">
        </select>
        
      </div>

      <!-- Changed Program Name -->
      <div id="changedProgramRequest" style="display:none;">
        <label class="block text-gray-700 mb-1">Changed Program Name</label>
        <input type="text" id="updatedCourseId" readonly class="w-full border rounded px-3 py-2 bg-gray-200 text-gray-500">
      </div>

      <!-- Batch -->
      <div>
        <label class="block text-gray-700 mb-1">Batch*</label>
        <select class="w-full border rounded px-3 py-2" id="batch" name="batch">
          <option value="">--Select Batch--</option>
          <option value="Degree Batch - 2025">Degree Batch - 2025</option>
          <option value="March 2025">March 2025
          <option value="June 2025">June 2025</option>
          <option value="August 2025">August 2025</option>   
          <option value="September 2025">September 2025</option>
          <option value="December 2025">December 2025</option>
        </select>
        <span class="text-red-600" id="batchError" style="font-size: 12px;"></span>
      </div>

      <!-- Registration Date -->
      <div>
        <label class="block text-gray-700 mb-1">Registration Date*</label>
        <input type="text" id="regDate" name="regDate" class="w-full border rounded px-3 py-2 bg-gray-200 text-gray-500" readonly>
      </div>

      <div>
        <label class="block text-gray-700 mb-1">Location*</label>
        <select class="w-full border rounded px-3 py-2" id="location" name="location">
          
        </select>
      </div>

    </div>

    <!-- Right capture picture box -->
<!-- Right capture picture box -->
<div class="flex justify-center items-center border rounded p-4">
  <div class="flex flex-col items-center">
    <img src="/images/Profile.png" alt="Captured Image" class="h-32 w-32 object-cover rounded mb-2">
    <button id="openModal" class="px-4 py-2 rounded hover:bg-red-600 bg-red-500 text-white">Capture Picture</button>
  </div>
</div>


  </div>
</div>


<!-- Finance Details -->
<!-- <div class="max-w-6xl mx-auto bg-white mt-6 rounded shadow" id="financeDetails">
  <!-- Red header -->
  <!-- <h2 class="text-lg font-bold text-white bg-red-600 px-4 py-2 rounded-t">Finance Details</h2>

  <div class="p-4 grid grid-cols-1 md:grid-cols-3 gap-4">
    <!-- Total Course Amount -->
    <!-- <div>
      <label class="block text-gray-700 mb-1">Total Course Amount</label>
      <input type="text" id="totalCourseAmt" name="totalCourseAmt" class="w-full border rounded px-3 py-2 bg-gray-200 text-gray-500" readonly>
      <input type="hidden" id="increemental_number" name="increemental_number" >
    </div> -->

    <!-- Course Amount Paid Till Now -->
    <!-- <div>
      <label class="block text-gray-700 mb-1">Course Amount Paid Till Now</label>
      <input type="text" id="totalAmountPaidNow" name="totalAmountPaidNow" class="w-full border rounded px-3 py-2 bg-gray-200 text-gray-500" readonly>
      <span class="text-red-600" id="totalAmountPaidNowError" style="font-size: 12px;"></span>
    </div> -->

    <!-- To Pay -->
    <!-- <div>
      <label class="block text-gray-700 mb-1">To Pay</label>
      <input type="text" id="toPay" name="toPay" class="w-full border rounded px-3 py-2">
    </div>
  </div> -->

  <!-- <div class="p-4 grid grid-cols-1 md:grid-cols-3 gap-4">
     Course Fee Balance -->
    <!-- <div>
      <label class="block text-gray-700 mb-1">Course Fee Balance</label>
      <input type="text" id="courseFeeBalance" name="courseFeeBalance" class="w-full border rounded px-3 py-2 bg-gray-200 text-gray-500" readonly>
    </div> -->

    <!-- Difference -->
    <!-- <div>
      <label class="block text-gray-700 mb-1">Difference</label>
      <input type="text" id="difference" name="difference" class="w-full border rounded px-3 py-2 bg-gray-200 text-gray-500" readonly>
    </div> -->

    <!-- Mode of Payment -->
    <!-- <div>
      <label class="block text-gray-700 mb-1">Mode of Payment*</label>
      <input type="text" id="modeOfPayment" name="modeOfPayment" class="w-full border rounded px-3 py-2">
      <span class="text-red-600" id="modeOfPaymentError" style="font-size: 12px;"></span>
    </div>
  </div>
</div>  -->




<!-- Personal Details -->
<div class="max-w-6xl mx-auto bg-white mt-6 rounded shadow" id="personalDetails">
  <!-- Red header -->
  <h2 class="text-lg font-bold text-white bg-red-600 px-4 py-2 rounded-t">Personal Details</h2>

  <div class="p-4 grid grid-cols-1 md:grid-cols-3 lg:grid-cols-4 gap-4">

    <!-- Unique ID -->
    <div>
      <input type="hidden" id="increemental_number" name="increemental_number" >
      <label class="block text-gray-700 mb-1">Unique ID</label>
      <input type="text" id="uniqueId" name="uniqueId" class="w-full border rounded px-3 py-2 bg-gray-200 text-gray-500" readonly>
    </div>

    <!-- Campus eMail ID -->
    <div>
      <label class="block text-gray-700 mb-1">Campus eMail ID</label>
      <input type="text" id="campusEmailId" name="campusEmailId" class="w-full border rounded px-3 py-2 bg-gray-200 text-gray-500" readonly>
    </div>

    <!-- First Name -->
    <div>
      <label class="block text-gray-700 mb-1">First Name*</label>
      <input type="text" id="firstName" name="firstName" class="w-full border rounded px-3 py-2" >
      <span class="text-red-600" id="firstNameError" style="font-size: 12px;"></span>
    </div>

    <!-- Middle Name -->
    <div>
      <label class="block text-gray-700 mb-1">Middle Name</label>
      <input type="text" id="middleName" name="middleName" class="w-full border rounded px-3 py-2">
    </div>

    <!-- Last Name -->
    <div>
      <label class="block text-gray-700 mb-1">Last Name</label>
      <input type="text" id="lastName" name="lastName" class="w-full border rounded px-3 py-2">
    </div>

    <!-- Full Name -->
    <div>
      <label class="block text-gray-700 mb-1">Full Name</label>
      <input type="text" id="fullName" name="fullName" class="w-full border rounded px-3 py-2 bg-gray-200 text-gray-500" readonly>
    </div>

    <!-- Contact Number -->
    <div>
      <label class="block text-gray-700 mb-1">Contact Number*</label>
      <input type="text" id="contactNumber" name="contactNumber" class="w-full border rounded px-3 py-2">
      <span class="text-red-600" id="contactNumberError" style="font-size: 12px;"></span>
    </div>

    <!-- Email -->
    <div>
      <label class="block text-gray-700 mb-1">Email</label>
      <input type="text" id="email" name="email" class="w-full border rounded px-3 py-2">
      <span class="text-red-600" id="emailError" style="font-size: 12px;"></span>
    </div>

    <!-- Date of Birth -->
    <div>
      <label class="block text-gray-700 mb-1">Date of Birth*</label>
      <input type="text" id="dob" name="dob" class="w-full border rounded px-3 py-2">
      <span class="text-red-600" id="dobError" style="font-size: 12px;"></span>
    </div>

    <!-- Gender -->
    <div>
      <label class="block text-gray-700 mb-1">Gender*</label>
      <select name="gender" id="gender" class="w-full border rounded px-3 py-2">
        <option value="">--Select Gender--</option>
        <option value="Male">Male</option>
        <option value="Female">Female</option>
        <option value="Other">Other</option>
      </select>
      <span class="text-red-600" id="genderError" style="font-size: 12px;"></span>
    </div>

    <!-- Blood Group -->
    <div>
      <label class="block text-gray-700 mb-1">Blood Group*</label>
      <select name="bloodGroup" id="bloodGroup" class="w-full border rounded px-3 py-2">
        <option value="">--Select Blood Group--</option>
        <option value="A+">A+</option>
        <option value="A-">A-</option>
        <option value="B+">B+</option>
        <option value="B-">B-</option>
        <option value="AB+">AB+</option>
        <option value="AB-">AB+</option>
        <option value="O+">O+</option>
        <option value="O-">O-</option>
      </select>
      <span class="text-red-600" id="bloodGroupError" style="font-size: 12px;"></span>
    </div>

    <!-- Nationality -->
    <!-- <div>
      <label class="block text-gray-700 mb-1">Nationality*</label>
      <input type="text" id="nationality" name="nationality" class="w-full border rounded px-3 py-2 bg-gray-200 text-gray-500" readonly>
    </div> -->

    <!-- Emergency Contact Number -->
    <div>
      <label class="block text-gray-700 mb-1">Emergency Contact Number*</label>
      <input type="text" id="emergencyContact" name="emergencyContact" class="w-full border rounded px-3 py-2">
      <span class="text-red-600" id="emergencyContactError" style="font-size: 12px;"></span>
    </div>

    

    <!-- Current Address -->
    <div class="md:col-span-4">
      <h3 class="text-md font-semibold mb-2">Current Address</h3>
    </div>

    <!-- Address Line 1 (Current) -->
 <div class="md:col-span-2">
  <label class="block text-gray-700 mb-1">Address Line 1*</label>
  <input type="text" id="currAddress1" name="currAddress1" maxlength="32" class="w-full border rounded px-3 py-2" oninput="validateLength(this, 'currAddress1Error')" />
  <span class="text-red-600" id="currAddress1Error" style="font-size: 12px;"></span>
</div>

    <!-- Address Line 2 (Current) -->
<div class="md:col-span-2">
  <label class="block text-gray-700 mb-1">Address Line 2*</label>
  <input type="text" id="currAddress2" name="currAddress" maxlength="32" class="w-full border rounded px-3 py-2" oninput="validateLength(this, 'currAddress1Error')" />
  <span class="text-red-600" id="currAddress2Error" style="font-size: 12px;"></span>
</div>

    <!-- Country (Current) -->
    <div>
      <label class="block text-gray-700 mb-1">Country</label>
      <input type="text" id="currCountry" name="currCountry" class="w-full border rounded px-3 py-2">
    </div>

    <!-- State (Current) -->
    <div>
      <label class="block text-gray-700 mb-1">State*</label>
      <select name="currState" id="currState" onchange="getCity(1);" class="w-full border rounded px-3 py-2">
        <option value="">--Select State--</option>
      </select>
      <span class="text-red-600" id="currStateError" style="font-size: 12px;"></span>
    </div>

    <!-- City (Current) -->
    <div>
      <label class="block text-gray-700 mb-1">City*</label>
      <select name="currCity" id="currCity" class="w-full border rounded px-3 py-2">
        <option value="">--Select City--</option>
      </select>
      <span class="text-red-600" id="currCityError" style="font-size: 12px;"></span>
    </div>

    <!-- Pincode (Current) -->
    <div>
      <label class="block text-gray-700 mb-1">Pincode*</label>
      <input type="text" id="currPincode" name="currPincode" class="w-full border rounded px-3 py-2">
      <span class="text-red-600" id="currPincodeError" style="font-size: 12px;"></span>
    </div>

    <!-- Checkbox: Is Permanent Address same -->
    <div class="md:col-span-4">
      <label class="inline-flex items-center mt-2">
        <input type="checkbox" id="sameAddress" class="form-checkbox h-5 w-5 text-red-600">
        <span class="ml-2 text-red-700">Is your permanent address same as current address?</span>
      </label>
    </div>

    <!-- Permanent Address -->
    <div class="md:col-span-4">
      <h3 class="text-md font-semibold mb-2 mt-4">Permanent Address</h3>
    </div>

    <!-- Address Line 1 (Permanent) -->
<div class="md:col-span-2">
  <label class="block text-gray-700 mb-1">Address Line 1*</label>
  <input type="text" id="permAddress1" name="permAddress1" maxlength="32" class="w-full border rounded px-3 py-2" oninput="validateLength(this, 'currAddress1Error')" />
  <span class="text-red-600" id="permAddress1Error" style="font-size: 12px;"></span>
</div>

    <!-- Address Line 2 (Permanent) -->
<div class="md:col-span-2">
  <label class="block text-gray-700 mb-1">Address Line 2*</label>
  <input type="text" id="permAddress2" name="permAddress2" maxlength="32" class="w-full border rounded px-3 py-2" oninput="validateLength(this, 'currAddress1Error')" />
  <span class="text-red-600" id="permAddress2Error" style="font-size: 12px;"></span>
</div>

    <!-- Country (Permanent) -->
    <div>
      <label class="block text-gray-700 mb-1">Country</label>
      <input type="text" id="permCountry" name="permCountry" class="w-full border rounded px-3 py-2">
    </div>

    <!-- State (Permanent) -->
    <div>
      <label class="block text-gray-700 mb-1">State*</label>
      <select name="permState" id="permState" class="w-full border rounded px-3 py-2" onchange="getCity(0);">
        <option value="">--Select State--</option>
      </select>
      <span class="text-red-600" id="permStateError" style="font-size: 12px;"></span>
    </div>

    <!-- City (Permanent) -->
    <div>
      <label class="block text-gray-700 mb-1">City*</label>
      <select name="permCity" id="permCity" class="w-full border rounded px-3 py-2">
        <option value="">--Select City--</option>
      </select>
      <span class="text-red-600" id="permCityError" style="font-size: 12px;"></span>
    </div>

    <!-- Pincode (Permanent) -->
    <div>
      <label class="block text-gray-700 mb-1">Pincode*</label>
      <input type="text" id="permPincode" name="permPincode" class="w-full border rounded px-3 py-2">
      <span class="text-red-600" id="permPincodeError" style="font-size: 12px;"></span>
    </div>

  </div>
</div>

<script>
  document.getElementById('sameAddress').addEventListener('change', function() {
    const isChecked = this.checked;

    const fields = ['Address1', 'Address2', 'Country', 'State', 'City', 'Pincode'];
    fields.forEach(field => {
      const curr = document.getElementById('curr' + field);
      const perm = document.getElementById('perm' + field);
      if (isChecked) {
        perm.value = curr.value;
        perm.readOnly = true;
        perm.disabled = true;
        perm.classList.add('bg-gray-200', 'text-gray-500');
        if(perm.tagName === 'SELECT' || perm.tagName === 'TEXTAREA'){
          perm.disabled = true;
        }
      } else {
        perm.value = '';
        perm.readOnly = false;
        perm.disabled = false;
        perm.classList.remove('bg-gray-200', 'text-gray-500');
        if(perm.tagName === 'SELECT' || perm.tagName === 'TEXTAREA'){
          perm.disabled = false;
        }
      }
    });
  });
</script>
    <!-- Father's Name
    <div>
      <label class="block text-gray-700 mb-1">Father's Name*</label>
      <input type="text" id="fatherName" name="fatherName" class="w-full border rounded px-3 py-2">
      <span class="text-red-600" id="fatherNameError" style="font-size: 12px;"></span>
    </div>

    Relationship with Applicant
    <div>
      <label class="block text-gray-700 mb-1">Relationship with Applicant*</label>
      <input type="text" id="fatherRelationship" name="fatherRelationship" class="w-full border rounded px-3 py-2">
      <span class="text-red-600" id="fatherRelationshipError" style="font-size: 12px;"></span>
    </div>

    Father Nationality
    <div>
      <label class="block text-gray-700 mb-1">Nationality</label>
      <input type="text" id="fatherNationality" name="fatherNationality" class="w-full border rounded px-3 py-2">
    </div>

    Mother's Name
    <div>
      <label class="block text-gray-700 mb-1">Mother's Name</label>
      <input type="text" id="motherName" name="motherName" class="w-full border rounded px-3 py-2">
      <span class="text-red-600" id="motherNameError" style="font-size: 12px;"></span>
    </div>    

    Relationship with Applicant
    <div>
      <label class="block text-gray-700 mb-1">Relationship with Applicant*</label>
      <input type="text" id="motherRelationship" name="motherRelationship" class="w-full border rounded px-3 py-2">
      <span class="text-red-600" id="motherRelationshipError" style="font-size: 12px;"></span>
    </div>

    Nationality
    <div>
      <label class="block text-gray-700 mb-1">Nationality*</label>
      <input type="text" id="motherNationality" name="motherNationality" class="w-full border rounded px-3 py-2">
    </div>

    Loan Required -->
    <!-- <div>
      <label class="block text-gray-700 mb-1">Loan Required*</label>
      <input type="text" id="loanRequired" name="loanRequired" class="w-full border rounded px-3 py-2">
    </div>

  </div>
</div> -->


<!-- Save Button -->
<div class="max-w-6xl mx-auto text-center my-6 flex justify-center">
  <!-- Save Button -->
  <div id="saveButton" class="mr-4">
    <button class="bg-black text-white px-8 py-2 rounded hover:bg-red-600" onclick="saveStudent()">Save</button>
  </div>
  <!-- Print Button -->
  <div id="printStaffButton">
    <button class="bg-black text-white px-8 py-2 rounded hover:bg-red-600" id="printStaffId" onclick="printStudent()">Print</button>
  </div>

<div id="myModal" class="hidden fixed inset-0 bg-gray-800 bg-opacity-50 flex items-center justify-center z-50">
    <!-- Modal content -->
    <div class="bg-white rounded-lg shadow-lg w-11/12 md:w-1/3 p-6">
      <h2 class="text-xl font-bold mb-4"></h2>
      <p class="mb-4">
	
	  	
		<!-- Main Content -->
		<div class="flex flex-col items-center justify-center mt-20">
		<!-- Profile Image with camera icon -->
		<div class="relative">
			<img id="profileImage" src="/images/Photo.png" alt="Profile" class="w-48 h-48 rounded-full border-4 border-gray-300 object-scale-down">
			<button id="openCameraBtn" class="absolute bottom-2 right-2 bg-gray-200 p-2 rounded-full">
			<svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 text-black" fill="none" viewBox="0 0 24 24" stroke="currentColor">
				<path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 7h4l2-3h6l2 3h4v13H3V7z" />
			</svg>
			</button>
		</div>
		<!-- Buttons -->
		<div class="mt-6 flex space-x-4">
			<button id="saveBtn" class="bg-black text-white px-8 py-2 rounded hover:bg-red-600">Save</button>
			<button id="retakeBtn" class="bg-gray-300 text-black px-8 py-2 rounded">Retake</button>
		</div>
		</div>
		<!-- Camera Modal -->
		<div id="cameraModal" class="fixed inset-0 bg-black bg-opacity-75 flex items-center justify-center hidden">
		<div class="bg-white p-4 rounded">
			<video id="video" width="320" height="240" autoplay class="border"></video>
			<div class="flex justify-center mt-4">
			<button id="captureBtn" class="bg-black text-white px-4 py-2 rounded hover:bg-red-600">Capture</button>
			<button id="closeCameraBtn" class="ml-4 bg-gray-300 text-black px-4 py-2 rounded">Close</button>
			</div>
		</div>
		</div>

	  </p>
      <div class="flex justify-end">
        <button id="closeModal" class="bg-red-500 text-white px-4 py-2 rounded hover:bg-red-600">
          Close
        </button>
      </div>
    </div>
  </div>

</body>
<script>
    const modal = document.getElementById('myModal');
    const openModal = document.getElementById('openModal');
    const closeModal = document.getElementById('closeModal');
    openModal.addEventListener('click', () => {
      modal.classList.remove('hidden');
    });
    closeModal.addEventListener('click', () => {
      modal.classList.add('hidden');
    });
    window.addEventListener('click', (e) => {
      if (e.target == modal) {
        modal.classList.add('hidden');
      }
    });
  </script>

<script>
$(document).ready(function () {
    $("#saveButton").hide();
    $("#academicDetails, #financeDetails, #personalDetails, #printStaffButton").hide();
    
    $('#studentSearch').autocomplete({
        source: function (request, response) {
            let numeric = $.isNumeric(request.term) ? 1 : 0;

            $.ajax({
                url: "/autocomplete-student-search",
                type: "GET",
                data: { term: request.term, numeric: numeric },
                success: function (data) {
                    const formatted = data.map(item => ({
                        label: item.full_name ?? item.contact_number,
                        value: item.full_name ?? item.contact_number,
                        status: item.completed_status
                    }));
                    response(formatted);
                }
            });
        },
        minLength: 2
    }).data("ui-autocomplete")._renderItem = function (ul, item) {
        const tick = item.status == 1 ? '<span style="color:green;">&#10004;</span>' : '';
        return $("<li>")
            .append(`<div style="display:flex; justify-content:space-between;">${item.label} ${tick}</div>`)
            .appendTo(ul);
    };
});

var student_unique_id = '';

  function captureImage() {
    $("#imagehdnStudentId").val($("#studentId").val());
    $("#captureImageModal").modal('show');
  }

  $("#studentSearch").focusout(function(){
    var studentName = $("#studentSearch").val();
    $.ajax({
      url: '/student-details-complete',
      type: 'GET',
      data: { student: studentName },
      success: function(data) {
        debugger;
        if (data.studentDetails.length > 0) {
          $("#academicDetails").show();
          $("#financeDetails").show();
          $("#personalDetails").show();
          $("#saveButton").show();
          var currstateId = $("#currState").empty();
          var permstateId = $("#permState").empty();
          var location = $("#location").empty();
          currstateId.append('<option value="">--Select State--</option>');
          permstateId.append('<option value="">--Select State--</option>');
          location.append('<option value="">--Select Location--</option>');

          for(var i=0; i < data.locationList.length > 0; i++)
          {
            var city_item_el = '<option value="' + data.locationList[i]+'">'+ data.locationList[i]+'</option>';
            location.append(city_item_el);
          }
          
          for(var i=0; i < data.stateList.length > 0; i++)
          {
              var city_item_el = '<option value="' + data.stateList[i]['state_name']+'">'+ data.stateList[i]['state_name']+'</option>';
              currstateId.append(city_item_el);
              permstateId.append(city_item_el);
          }

          var currCityId = $("#currCity").empty();
          var permCityId = $("#permCity").empty();
          currCityId.append('<option value="">--Select City--</option>');
          permCityId.append('<option value="">--Select City--</option>');

          for(var i=0; i < data.currCityList.length > 0; i++)
          {
              var city_item_el = '<option value="' + data.currCityList[i]['city_name']+'">'+ data.currCityList[i]['city_name']+'</option>';
              currCityId.append(city_item_el);
              permCityId.append(city_item_el);
          }
          student_unique_id = data.studentDetails[0].aaft_unique_id;
          var number = data.studentDetails[0].campus_email_id;
          var increementalNumber = data.studentDetails[0].increemental_number == "" || data.studentDetails[0].increemental_number == null ? number.match(/\d+/g) : data.studentDetails[0].increemental_number;
          var fullName = data.studentDetails[0].full_name == "" ||data.studentDetails[0].full_name == null ? data.studentDetails[0].first_name + " " + (data.studentDetails[0].middle_name == null ? "" : data.studentDetails[0].middle_name) + " " + (data.studentDetails[0].last_name == null ? "" : data.studentDetails[0].last_name) : data.studentDetails[0].full_name;
          var dateofBirth = data.studentDetails[0].dob;
          //var datetime = "2025-08-05 14:30:00"; // or "2025-08-05T14:30:00Z"

          // Convert to Date object
          var dateObj = new Date(dateofBirth);

          if (!isNaN(dateObj.getTime())) {
              // Format to dd-mm-yyyy
              var day = String(dateObj.getDate()).padStart(2, '0');
              var month = String(dateObj.getMonth() + 1).padStart(2, '0'); // months are 0-based
              var year = dateObj.getFullYear();

              var formattedDate = day + '-' + month + '-' + year;
          } else {
              var formattedDate = dateofBirth; // fallback if date is invalid
          }

          $("#hdnCourseCode").val(data.courseCode[0]);
          $("#studentId").val(data.studentDetails[0].student_id);
          $("#prospect_id").val(data.studentDetails[0].prospect_id);
          $("#school").val(data.studentDetails[0].school);
          $("#course").val(data.studentDetails[0].course);
          $("#programType").val(data.studentDetails[0].program_type);
          $("#programDuration").val(data.studentDetails[0].program_duration);
          $("#batch").val(data.studentDetails[0].batch);
          $("#regDate").val(data.studentDetails[0].registration_date);
          $("#batch").val(data.studentDetails[0].batch_code);
          $("#increemental_number").val(increementalNumber[0]);
          $("#totalCourseAmt").val(data.studentDetails[0].total_fees);
          $("#totalAmountPaidNow").val(data.studentDetails[0].amount_paid_till_now);
          $("#toPay").val(data.studentDetails[0].to_pay);
          $("#courseFeeBalance").val(data.studentDetails[0].course_fee_balance);
          $("#difference").val(data.studentDetails[0].difference);
          $("#modeOfPayment").val(data.studentDetails[0].mode_payment);          
          $("#uniqueId").val(data.studentDetails[0].aaft_unique_id);
          $("#campusEmailId").val(data.studentDetails[0].campus_email_id);
          $("#firstName").val(data.studentDetails[0].first_name);
          $("#middleName").val(data.studentDetails[0].middle_name);
          $("#lastName").val(data.studentDetails[0].last_name);
          $("#fullName").val(fullName);
          $("#contactNumber").val(data.studentDetails[0].contact_number);
          $("#email").val(data.studentDetails[0].email);
          $("#dob").val(formattedDate);
          $("#gender").val(data.studentDetails[0].gender);
          $("#bloodGroup").val(data.studentDetails[0].blood_group);
          $("#nationality").val(data.studentDetails[0].nationality);
          $("#emergencyContact").val(data.studentDetails[0].emergency_contact);
          $("#currAddress1").val(data.studentDetails[0].curr_address1);
          $("#currAddress2").val(data.studentDetails[0].curr_address2);
          $("#currCountry").val(data.studentDetails[0].curr_country);
          $("#currState").val(data.studentDetails[0].curr_state);
          $("#currCity").val(data.studentDetails[0].curr_city);
          $("#currPincode").val(data.studentDetails[0].curr_pincode);
          $("#permAddress1").val(data.studentDetails[0].perm_address1);
          $("#permAddress2").val(data.studentDetails[0].perm_address2);
          $("#permCountry").val(data.studentDetails[0].perm_country);
          $("#permState").val(data.studentDetails[0].perm_state);
          $("#permCity").val(data.studentDetails[0].perm_city);
          $("#permPincode").val(data.studentDetails[0].perm_pincode);
          $("#fatherName").val(data.studentDetails[0].father_name);
          $("#fatherRelationship").val(data.studentDetails[0].father_relationship);
          $("#fatherNationality").val(data.studentDetails[0].father_nationality);
          $("#motherName").val(data.studentDetails[0].mother_name);
          $("#motherRelationship").val(data.studentDetails[0].mother_relationship);
          $("#motherNationality").val(data.studentDetails[0].mother_nationality);
          $("#loanRequired").val(data.studentDetails[0].loan_required);          
        } else {
          alert('No student found with that name or contact');
        }
      },
      error: function() {
        alert('Error fetching student details');
      }
    });
  });

  function getCity(id) {
    if(id == 1){
        var stateId = $("#currState").val();
    } else {
        var stateId = $("#permState").val();
    }        
             
        $.ajax({
            type: "GET",
            url: "/get-city",
            data: { stateId: stateId },
            success: function(data) {
              debugger;
                if(data.length > 0) {
                if(id == 1){
                    var cityId = $("#currCity").empty();
                } else {
                    var cityId = $("#permCity").empty();
                }                   
                    
                    cityId.append('<option selected="selected" value="">--Select City--</option>');
                    for(var i = 0; i < data.length;i++){
                        var city_item_el = '<option value="' + data[i]['city_name']+'">'+ data[i]['city_name']+'</option>';
                        cityId.append(city_item_el);
                    }
                }
            }
        });
    }

  function saveStudent(){
    debugger;
    var school = $("#school").val();
    var course = $("#course").val();
    var programType = $("#programType").val();
    var programDuration = $("#programDuration").val();
    var batch = $("#batch").val();
    var regDate = $("#regDate").val();
    //var totalCourseAmt = $("#totalCourseAmt").val();
    //var totalAmountPaidNow = $("#totalAmountPaidNow").val();
    //var toPay = $("#toPay").val();
    //var courseFeeBalance = $("#courseFeeBalance").val();
    //var difference = $("#difference").val();
    //var modeOfPayment = $("#modeOfPayment").val();
    var imgName = $("#hdnImageName").val();
    var imgPath = $("#hdnImagePath").val();
    var uniqueId = student_unique_id == undefined ? $("#uniqueId").val() : student_unique_id;
    var campusEmailId = $("#campusEmailId").val();
    var firstName = $("#firstName").val();
    var middleName = $("#middleName").val();
    var lastName = $("#lastName").val();
    var fullName = $("#fullName").val();
    var contactNumber = $("#contactNumber").val();
    var email = $("#email").val();
    var dob = $("#dob").val();
    var gender = $("#gender").val();
    var bloodGroup = $("#bloodGroup").val();
    //var nationality = $("#nationality").val();
    var emergencyContact = $("#emergencyContact").val();
    var currAddress1 = $("#currAddress1").val();
    var currAddress2 = $("#currAddress2").val();
    var currCountry = $("#currCountry").val();
    var currState = $("#currState").val();
    var currCity = $("#currCity").val();
    var currPincode = $("#currPincode").val();
    var permAddress1 = $("#permAddress1").val();
    var permAddress2 = $("#permAddress2").val();
    var permCountry = $("#permCountry").val();
    var permState = $("#permState").val();
    var permCity = $("#permCity").val();
    var permPincode = $("#permPincode").val();
    var location = $("#location").val();
    //var fatherName = $("#fatherName").val();
    //var fatherRelationship = $("#fatherRelationship").val();
    //var fatherNationality = $("#fatherNationality").val();
    //var motherName = $("#motherName").val();
    //var motherRelationship = $("#motherRelationship").val();
    //var motherNationality = $("#motherNationality").val();
    //var loanRequired = $("#loanRequired").val();
    var studentId = $("#studentId").val();
    var prospectId = $("#prospect_id").val();
    var increementalNumber = $("#increemental_number").val();

    var batchCode1 = '';
    var programCode1 = '';
  if($("#programType").val() == "Degree")
        {
            programCode1 = "UG";            
        }
        else if($("#programType").val() == "Diploma")
        {
          programCode1 = "DP";            
        }
        else if($("#programType").val() == "Certificate")
        {
          programCode1 = "CE";            
        }
        else if($("#programType").val() == "Post Graduate")
        {
          programCode1 = "PG";            
        }
        else if($("#programType").val() == "PG Diploma")
        {
          programCode1 = "PGDP";            
        }

        if($("#batch").val() == "Degree Batch - 2025")
        {
          batchCode1 = "825";
        }
        else if($("#batch").val() == "March 2025")
        {
          batchCode1 = "124";
        }
        else if($("#batch").val() == "June 2025")
        {
          batchCode1 = "125";
        }
        else if($("#batch").val() == "August 2025")
        {
          batchCode1 = "126";
        }
        else if($("#batch").val() == "September 2025")
        {
          batchCode1 = "127";
        }
        else if($("#batch").val() == "December 2025")
        {
          batchCode1 = "128";
        }
        var student_unique_id = 'AN' + programCode1 + $("#hdnCourseCode").val() + batchCode1 + increementalNumber;
        if($("#programType").val() == "Degree" || $("#programType").val() == "Post Graduate")
        {
          campusEmailId = firstName + '_' + increementalNumber + '@aaft.ac.in';
        }
        else 
        {
          campusEmailId = firstName + '_' + increementalNumber + '@aaft.net';
        }
        
    // if(totalAmountPaidNow == "" || totalAmountPaidNow == null){
    //     $("#totalAmountPaidNowError").empty().html("Please enter Course Amount Paid Till Now");
    // }
    // else {
    //     $("#totalAmountPaidNowError").empty().html("");
    // }

    if(batch == "" || batch == null){
        $("#batchError").empty().html("Please select Batch");
    }
    else {
        $("#batchError").empty().html("");
    }

    // if(modeOfPayment == "" || modeOfPayment == null){
    //     $("#modeOfPaymentError").empty().html("Please enter Mode of Payment");
    // }
    // else {
    //     $("#modeOfPaymentError").empty().html("");
    // }

    if(firstName == "" || firstName == null){
        $("#firstNameError").empty().html("Please enter First Name");
    }
    else {
        $("#firstNameError").empty().html("");
    }

    if(contactNumber == "" || contactNumber == null){
        $("#contactNumberError").empty().html("Please enter Contact Number");
    }
    else {
        $("#contactNumberError").empty().html("");
    }

    if(email == "" || email == null){
        $("#emailError").empty().html("Please enter Email");
    }
    
    else {
        $("#emailError").empty().html("");
    }

    if(dob == "" || dob == null){
      $("#dobError").empty().html("Please enter Date of Birth");
    }
    else {
      $("#dobError").empty().html("");
    }

    if(gender == "" || gender == null) {
      $("#genderError").empty().html("Please select the gender");
    }
    else {
      $("#genderError").empty().html("");
    }

    if(bloodGroup == "" || bloodGroup == null) {
      $("#bloodGroupError").empty().html("Please select the blood group");
    }
    else {
      $("#bloodGroupError").empty().html("");
    }

    if(emergencyContact == "" || emergencyContact == null) {
      $("#emergencyContactError").empty().html("Please enter the emergency contact number");
    }
    else {
      $("#emergencyContactError").empty().html("");
    }

    if(currAddress1 == "" || currAddress1 == null) {
      $("#currAddress1Error").empty().html("Please enter the current address line 1");
    }
    else {
      $("#currAddress1Error").empty().html("");
    }
    

    if(currState == "" || currState == null) {
      $("#currStateError").empty().html("Please select the current state");
    }
    else {
      $("#currStateError").empty().html("");
    }

    if(currCity == "" || currCity == null) {
      $("#currCityError").empty().html("Please select the current city");
    }
    else {
      $("#currCityError").empty().html("");
    }

    if(currPincode == "" || currPincode == null) {
      $("#currPincodeError").empty().html("Please enter the current pincode");
    }
    else {
      $("#currPincodeError").empty().html("");
    }

    if(permAddress1 == "" || permAddress1 == null) {
      $("#permAddress1Error").empty().html("Please enter the permanent address line 1");
    }
    else {
      $("#permAddress1Error").empty().html("");
    }

    if(permState == "" || permState == null) {
      $("#permStateError").empty().html("Please select the permanent state");
    }
    else {
      $("#permStateError").empty().html("");
    }

    if(permCity == "" || permCity == null) {
      $("#permCityError").empty().html("Please select the permanent city");
    }
    else {
      $("#permCityError").empty().html("");
    }

    if(permPincode == "" || permPincode == null) {
      $("#permPincodeError").empty().html("Please enter the permanent pincode");
    }
    else {
      $("#permPincodeError").empty().html("");
    }

    // if(fatherName == "" || fatherName == null) {
    //   $("#fatherNameError").empty().html("Please enter the father's name");
    // }
    // else {
    //   $("#fatherNameError").empty().html("");
    // }

    // if(fatherRelationship == "" || fatherRelationship == null) {
    //   $("#fatherRelationshipError").empty().html("Please enter the relationship with applicant");
    // }
    // else {
    //   $("#fatherRelationshipError").empty().html("");
    // }

    // if(motherName == "" || motherName == null) {
    //   $("#motherNameError").empty().html("Please enter the mother's name");
    // }
    // else {
    //   $("#motherNameError").empty().html("");
    // }

    // if(motherRelationship == "" || motherRelationship == null) {
    //   $("#motherRelationshipError").empty().html("Please enter the relationship with applicant");
    // }
    // else {
    //   $("#motherRelationshipError").empty().html("");
    // }

    if($("#totalAmountPaidNowError").text() != "" || $("#batchError").text() != "" ||
       $("#modeOfPaymentError").text() != "" || $("#firstNameError").text() != "" ||
       $("#contactNumberError").text() != "" || $("#emailError").text() != "" ||
       $("#dobError").text() != "" || $("#genderError").text() != "" ||
       $("#bloodGroupError").text() != "" || $("#emergencyContactError").text() != "" ||
       $("#currAddress1Error").text() != "" || $("#currStateError").text() != "" ||
       $("#currCityError").text() != "" || $("#currPincodeError").text() != "" ||
       $("#permAddress1Error").text() != "" || $("#permStateError").text() != "" ||
       $("#permCityError").text() != "" || $("#permPincodeError").text() != "" ||
       $("#fatherNameError").text() != "" || $("#fatherRelationshipError").text() != "" ||
       $("#motherNameError").text() != "" || $("#motherRelationshipError").text() != "") {
        return false;
    }
    else {
      if(imgName == "" )
      {
        alert("Please upload the photo");
        return false;
      }      
      // Submit form 
      let formData = new FormData();
      formData.append('school', school);
      formData.append('course', course);
      formData.append('programType', programType);
      formData.append('programDuration', programDuration);
      formData.append('batch', batch);
      formData.append('regDate', regDate);
      // formData.append('totalCourseAmt', totalCourseAmt);
      // formData.append('totalAmountPaidNow', totalAmountPaidNow);
      // formData.append('toPay', toPay);
      // formData.append('courseFeeBalance', courseFeeBalance);
      // formData.append('difference', difference);
      // formData.append('modeOfPayment', modeOfPayment);
      formData.append('uniqueId', student_unique_id);
      formData.append('campusEmailId', campusEmailId);
      formData.append('firstName', firstName);
      formData.append('middleName', middleName);
      formData.append('lastName', lastName);
      formData.append('fullName', fullName);
      formData.append('contactNumber', contactNumber);
      formData.append('email', email);
      formData.append('dob', dob);
      formData.append('gender', gender);
      formData.append('bloodGroup', bloodGroup);
      //formData.append('nationality', nationality);
      formData.append('emergencyContact', emergencyContact);
      formData.append('currAddress1', currAddress1);
      formData.append('currAddress2', currAddress2);
      formData.append('currCountry', currCountry);
      formData.append('currState', currState);
      formData.append('currCity', currCity);
      formData.append('currPincode', currPincode);
      formData.append('permAddress1', permAddress1);
      formData.append('permAddress2', permAddress2);
      formData.append('permCountry', permCountry);
      formData.append('permState', permState);
      formData.append('permCity', permCity);
      formData.append('permPincode', permPincode);
      formData.append('location', location);
      // formData.append('fatherName', fatherName);
      // formData.append('fatherRelationship', fatherRelationship);
      // formData.append('fatherNationality', fatherNationality);
      // formData.append('motherName', motherName);
      // formData.append('motherRelationship', motherRelationship);
      // formData.append('motherNationality', motherNationality);
      // formData.append('loanRequired', loanRequired);
      formData.append('studentId', studentId);
      formData.append('prospectId', prospectId);
      formData.append('increementalNumber', increementalNumber);
      formData.append('imgName', imgName);
      formData.append('imgPath', imgPath);
      
      formData.append('_token', '{{ csrf_token() }}');
      $.ajax({
                        type: "POST",
                        url: "{{  url('submit-student-details') }}",
                        data: formData,
                        contentType: false,
                        processData: false,
                        success: function(response) {
                          debugger;
                            if(response.success == "Student details updated successfully") {
                                alert("Student details updated successfully.");
                                $("#printStaffButton").show();
                            } else {
                                alert("Error saving student details: " + response.message);
                            }
                        }
                    });

    }
    
  }  

  function changeProgramRequest(){
    $.ajax({
      url: '/change-program-request',
      type: 'GET',
      success: function(data) {          
        debugger;
          $("#changedProgramRequest").show();
          $("#changeProgramRequest").show();
          $("#programRequestId").hide();
          var currstateId = $("#changedCourseId").empty();
          currstateId.append('<option value="">--Select Course--</option>');
          for(var i=0; i < data.length > 0; i++)
          {
              var city_item_el = '<option value="' + data[i]['course_name']+'">'+ data[i]['course_name']+'</option>';
              currstateId.append(city_item_el);              
          }
        
      },
      error: function() {
        alert('Error submitting change program request');
      }
    });
  }

  function updateCourse()
  {
    $("#updatedCourseId").val($("#changedCourseId").val());
    $.ajax({
      url: '/updateCourse',
      type: 'GET',
      data: { updatedCourseId: $("#changedCourseId").val() },
      success: function(data) {          
        if(data.courseList.length > 0)
        {
          
          $("#school").val(data.courseList[0].school_name);
          $("#course").val(data.courseList[0].course_name);
          $("#programType").val(data.courseList[0].program_name);
          $("#programDuration").val(data.courseList[0].course_duration); 
          $("#hdnCourseCode").val(data.courseList[0].course_code);
          var totalFee = data.courseList[0].total_course_fee
          $("#totalCourseAmt").val(totalFee);
          var amountPaidTillNow = $("#totalAmountPaidNow").val();
          var feeBalance = totalFee - amountPaidTillNow
          $("#courseFeeBalance").val(feeBalance);

                    
        }
      },
      error: function() {
        alert('Error updating program request');
      }
    });
  }

  function printStudent()
    {   
      
      var imgName = $("#hdnImageName").val();
      var imgPath = $("#hdnImagePath").val();
      var studentId1 = $("#studentId").val();

      if(imgName == "" || imgName == undefined) {
        alert("Please capture the image");
        return;
      }
      else {
        $.ajax({
            url: '/print-student-details',
            type: 'GET',
            data: { studentId1: studentId1 },
            success: function(response) {  
                       
                if(response.message == "Printed") {
                    alert("Student ID Card printed successfully");
                }
                else if(response.message == "ID card already printed") {
                  alert("ID card is already printed, please contact admin for any changes.");
                }
                else {
                    alert("Error updating staff details, please contact admin");
                }
            }
        });
      }
    }

    // function print()
    // {
    //     $.ajax({
    //     url: '/run-batch',
    //     type: 'GET',
    //     success: function(data) {          
    //       alert("Success");  
    //     }        
    //   });
    // }

  let stream;
// Initialize camera on page load
window.addEventListener('load', function() {
  navigator.mediaDevices.getUserMedia({ video: true })
  .then(function(s) {
    stream = s;
    document.getElementById('video').srcObject = stream;
  })
  .catch(function(err) {
    alert("Camera not accessible: " + err);
  });
});
// Open camera modal without re-requesting permission
document.getElementById('openCameraBtn').addEventListener('click', function() {
  document.getElementById('cameraModal').classList.remove('hidden');
});
// Capture image from video
document.getElementById('captureBtn').addEventListener('click', function() {
  const video = document.getElementById('video');
  const canvas = document.createElement('canvas');
  canvas.width = video.videoWidth;
  canvas.height = video.videoHeight;
  const ctx = canvas.getContext('2d');
  ctx.drawImage(video, 0, 0, canvas.width, canvas.height);
  // Set captured image as profile image
  document.getElementById('profileImage').src = canvas.toDataURL('image/png');
  document.getElementById('cameraModal').classList.add('hidden');
});
// Close camera modal without stopping stream
document.getElementById('closeCameraBtn').addEventListener('click', function() {
  document.getElementById('cameraModal').classList.add('hidden');
});
// Retake image: reset to placeholder and reopen camera modal
document.getElementById('retakeBtn').addEventListener('click', function() {
  document.getElementById('profileImage').src = "Photo.png";
  document.getElementById('cameraModal').classList.remove('hidden');
});
// Save image (download to local)
document.getElementById('saveBtn').addEventListener('click', function() {
  const image = document.getElementById('profileImage').src;
  // Check if image is captured (not placeholder)
  if(image.includes('Photo.png')){
    alert("No image captured to save.");
    return;
  }
  // Create a download link
  const link = document.createElement('a');
  var programCode = '';
  const courseCode = $("#hdnCourseCode").val();
  const increementalNumber = $("#increemental_number").val();
  var batchCode = '';
  if($("#programType").val() == "Degree")
        {
            programCode = "UG";            
        }
        else if($("#programType").val() == "Diploma")
        {
            programCode = "DP";            
        }
        else if($("#programType").val() == "Certificate")
        {
            programCode = "CE";            
        }
        else if($("#programType").val() == "Post Graduate")
        {
            programCode = "PG";            
        }
        else if($("#programType").val() == "PG Diploma")
        {
            programCode = "PGDP";            
        }

        if($("#batch").val() == "Degree Batch - 2025")
        {
          batchCode = "825";
        }
        else if($("#batch").val() == "March 2025")
        {
          batchCode = "124";
        }
        else if($("#batch").val() == "June 2025")
        {
          batchCode = "125";
        }
        else if($("#batch").val() == "August 2025")
        {
          batchCode = "126";
        }
        else if($("#batch").val() == "September 2025")
        {
          batchCode = "127";
        }
        else if($("#batch").val() == "December 2025")
        {
          batchCode = "128";
        }
  link.href = image;
  
  student_unique_id = 'AN' + programCode + courseCode + batchCode + increementalNumber;
  $("#hdnImageName").val(student_unique_id + '.jpg');
  link.download = student_unique_id + '.jpg';
  document.body.appendChild(link);
  link.click();
  document.body.removeChild(link);
});
// Stop camera stream when user leaves page
window.addEventListener('beforeunload', function() {
  if (stream) {
    stream.getTracks().forEach(track => track.stop());
  }
});


</script>
</html>
