
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>AAFT Admission Services Login</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <!-- Tailwind CDN -->
    <script src="https://cdn.tailwindcss.com"></script>
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/1.9.1/jquery.js"></script>

</head>
<body class="bg-cover bg-center min-h-screen" style="background-image: url('/images/campus.png');">

<!-- Header -->
<div class="bg-black flex flex-col sm:flex-row justify-between items-center p-4">
    <img src="<?php echo e(url('/images/Aaft.png')); ?>" alt="AAFT Logo" class="h-12 mb-2 sm:mb-0">
    <h1 class="text-white text-lg font-bold">AAFT Admission Services</h1>
    <img src="<?php echo e(url('/images/Asms.png')); ?>" alt="ASMS Logo" class="h-12 mt-2 sm:mt-0">
</div>

<!-- Login Box -->
<div class="flex items-center justify-center min-h-screen py-12 px-4 sm:px-6 lg:px-8">
    <div class="max-w-md w-full bg-white p-8 rounded shadow">
        <h2 class="mb-6 text-center text-2xl font-bold">Login in to your account</h2>      
        <form class="space-y-4" id="loginForm">
            <div>
                <input type="email" id="email" name="email" placeholder="Email ID"
                       class="appearance-none rounded w-full px-3 py-2 border border-gray-300 placeholder-gray-500 focus:outline-none focus:ring-2 focus:ring-blue-500">
                <span class="text-red-600" id="emailError" style="font-size: 12px;"></span>
            </div>
            <div>
                <input type="password" id="password" name="password" placeholder="Password"
                       class="appearance-none rounded w-full px-3 py-2 border border-gray-300 placeholder-gray-500 focus:outline-none focus:ring-2 focus:ring-blue-500">
                <span class="text-red-600" id="passwordError" style="font-size: 12px;"></span>
            </div>
            <div>
                <button type="button" onclick="login()"
                        class="group relative w-full flex justify-center py-2 px-4 border border-transparent text-sm font-medium rounded bg-black text-white hover:bg-gray-800 focus:outline-none">
                    Login
                </button>
            </div>
            <div>
                <a href="/fetchLsqData">Fetch Data</a>
            </div>
        </form>
    </div>
</div>
</body>
<script>
    function login() {
        // Add your login logic here
        var email = $("#email").val();
        var password = $("#password").val();
        if(email == "") {
            $("#emailError").empty().html("Email is required");
            return;
        } else {
            $("#emailError").empty();
        }
        
        if(password == "") {
            $("#passwordError").empty().html("Password is required");
            return;
        } else {
            $("#passwordError").empty();
        }
        
        if($("#emailError").html() != "" || $("#passwordError").html() != "") {
            return;
        }
         

        $.ajax({
            url: '/login', // Adjust the URL to your login endpoint
            type: 'get',
            data: {
                email: email,
                password: password
            },
            success: function(data) {
                debugger;
                if (data['loginMsg'] == "Invalid email") {
                        $("#passwordError").empty().html("Invalid email or password");
                        
                    } else {
                        window.location = data['loginMsg'];
                    }
            },
            error: function(xhr, status, error) {
                alert('An error occurred: ' + error);
            }
        });
        
    }
</script>
</html>
<?php /**PATH /var/www/html/aaft-admission-services/resources/views/sales_login.blade.php ENDPATH**/ ?>